/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import io.wispforest.alloyforgery.mixin.PreparedRecipesAccessor;
import io.wispforest.alloyforgery.mixin.ServerRecipeManagerAccessor;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public final class RecipeInjector {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Event<AddRecipes> ADD_RECIPES = EventFactory.createArrayBacked(AddRecipes.class, addRecipes -> instance -> {
        for (AddRecipes addRecipe : addRecipes) {
            addRecipe.addRecipes(instance);
        }
    });
    private final class_1863 manager;
    private final class_1937 world;
    private final Multimap<class_3956<?>, class_8786<?>> recipes = HashMultimap.create();
    private final Map<class_2960, class_8786<?>> recipesById = new HashMap();

    public RecipeInjector(class_1863 manager, class_1937 world) {
        this.manager = manager;
        this.world = world;
    }

    public <R extends class_1860<T>, T extends class_9695> void addRecipe(class_2960 id, R recipe) {
        if (class_7923.field_41188.method_10221((Object)recipe.method_17716()) == null) {
            throw new IllegalStateException("Unable to add Recipe for a RecipeType not registered!");
        }
        class_3956 type = recipe.method_17716();
        boolean bl = this.getAllOfType(type).stream().anyMatch(recipeEntry -> id.equals((Object)recipeEntry.comp_1932().method_29177()));
        if (bl) {
            LOGGER.error("[RecipeInjector]: Unable to add a given recipe due to being the same Identifier with the given Type. [ID: {}]", (Object)id);
            return;
        }
        class_8786 recipeEntry2 = new class_8786(class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)id), recipe);
        this.recipes.put((Object)recipe.method_17716(), (Object)recipeEntry2);
        this.recipesById.put(id, recipeEntry2);
    }

    public <I extends class_9695, T extends class_1860<I>> Stream<class_8786<T>> getAllMatches(class_3956<T> type, I input, class_1937 world) {
        return GeneralPlatformUtils.INSTANCE.getAllMatches(this.manager, type, input, world);
    }

    public <I extends class_9695, T extends class_1860<I>> Collection<class_8786<T>> getAllOfType(class_3956<T> type) {
        return GeneralPlatformUtils.INSTANCE.getAllOfType(this.manager, type);
    }

    public class_1863 manager() {
        return this.manager;
    }

    public class_7225.class_7874 lookup() {
        return ((ServerRecipeManagerAccessor)this.manager).af$getRegistryLookup();
    }

    public List<class_1799> getStacks(class_1856 ingredient) {
        class_10352 ctx = class_10363.method_65008((class_1937)this.world);
        return ingredient.method_64673().method_64738(ctx);
    }

    public static void injectRecipes(MinecraftServer server) {
        class_1863 manager = server.method_3772();
        RecipeInjector injector = new RecipeInjector(server.method_3772(), (class_1937)server.method_3847(class_1937.field_25179));
        ((AddRecipes)ADD_RECIPES.invoker()).addRecipes(injector);
        PreparedRecipesAccessor preparedRecipesAccessor = (PreparedRecipesAccessor)((ServerRecipeManagerAccessor)manager).af$preparedRecipes();
        injector.recipes.putAll(preparedRecipesAccessor.af$getRecipes());
        injector.recipesById.putAll(preparedRecipesAccessor.af$getRecipesById());
        preparedRecipesAccessor.af$setRecipes((Multimap<class_3956<?>, class_8786<?>>)ImmutableMultimap.copyOf(injector.recipes));
        preparedRecipesAccessor.af$setRecipesById((Map<class_2960, class_8786<?>>)ImmutableMap.copyOf(injector.recipesById));
        injector.recipes.clear();
        injector.recipesById.clear();
    }

    public static interface AddRecipes {
        public void addRecipes(RecipeInjector var1);
    }
}

