package io.wispforest.alloyforgery.mixin;

import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.class_2960;
import net.minecraft.class_5350;
import net.minecraft.class_8786;

@Mixin(class_5350.class)
public abstract class DataPackContentsMixin {
    @Inject(method = "applyPendingTagLoads", at = @At("TAIL"))
    private void alloy_forgery$onRefresh(CallbackInfo ci) {
        var contents = ((class_5350) (Object) this);

        var recipeEntries = GeneralPlatformUtils.INSTANCE.getAllOfType(contents.method_29471(), AlloyForgeRecipe.Type.INSTANCE);

        var map = new HashMap<AlloyForgeRecipe, class_2960>();

        for (var entry : recipeEntries) {
            map.put(entry.comp_1933(), entry.comp_1932().method_29177());
        }

        AlloyForgeRecipe.PENDING_RECIPES.forEach((recipe, pendingRecipeData) -> recipe.finishRecipe(contents.method_58297().method_58294(), pendingRecipeData, key -> map.getOrDefault(key, class_2960.method_60655(AlloyForgery.MOD_ID, "unknown_recipe"))));

        AlloyForgeRecipe.PENDING_RECIPES.clear();
    }
}
