/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.client;

import io.wispforest.alloyforgery.AlloyForgeScreenHandler;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.client.ComponentUtils;
import io.wispforest.alloyforgery.client.FixedSpriteComponent;
import io.wispforest.alloyforgery.networking.AlloyForgeNetworking;
import io.wispforest.alloyforgery.networking.DisableSlotToggle;
import io.wispforest.alloyforgery.utils.ForgeInputSlot;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.List;
import net.minecraft.class_1059;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4730;
import org.jetbrains.annotations.NotNull;

public class AlloyForgeScreen
extends BaseOwoHandledScreen<FlowLayout, AlloyForgeScreenHandler> {
    private static final class_4730 LAVA_SPRITE = new class_4730(class_1059.field_5275, class_2960.method_60654((String)"block/lava_still"));
    private static final class_2561 ENABLED_SLOT_TEXT = class_2561.method_43471((String)"tooltip.alloy-forgery.enabled_slot");
    private static final class_2561 DISABLED_SLOT_TEXT = class_2561.method_43471((String)"tooltip.alloy-forgery.disabled_slot");
    private TextureComponent fuelGauge;
    private TextureComponent progressGauge;
    private TextureComponent invalidCross;
    private FlowLayout lavaBar;
    private boolean allowSlotToggling = false;

    public AlloyForgeScreen(AlloyForgeScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 176;
        this.field_2779 = 189;
        this.field_25268 = 69420;
        this.field_25270 = this.field_2779 - 93;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        this.fuelGauge = (TextureComponent)Components.texture((class_2960)ComponentUtils.themedTextureID("fuel_meter.png"), (int)22, (int)0, (int)22, (int)48, (int)44, (int)48).visibleArea(PositionedRectangle.of((int)0, (int)0, (int)22, (int)0)).configure(textureComponent -> textureComponent.positioning(Positioning.absolute((int)5, (int)22)).id("fuel-gauge"));
        this.progressGauge = (TextureComponent)Components.texture((class_2960)ComponentUtils.textureID("forging_status.png"), (int)24, (int)3, (int)15, (int)19, (int)40, (int)22).visibleArea(PositionedRectangle.of((int)0, (int)0, (int)15, (int)0)).configure(textureComponent -> textureComponent.positioning(Positioning.absolute((int)147, (int)24)).id("progress-gauge"));
        this.invalidCross = (TextureComponent)Components.texture((class_2960)ComponentUtils.textureID("cross.png"), (int)0, (int)0, (int)14, (int)14, (int)14, (int)14).visibleArea(PositionedRectangle.of((int)0, (int)0, (int)14, (int)0)).configure(textureComponent -> textureComponent.positioning(Positioning.absolute((int)147, (int)25)).id("invalid-cross"));
        this.lavaBar = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fixed((int)0), (Sizing)Sizing.fixed((int)10)).child((Component)FixedSpriteComponent.fixedSprite(LAVA_SPRITE)).child((Component)FixedSpriteComponent.fixedSprite(LAVA_SPRITE)).child((Component)FixedSpriteComponent.fixedSprite(LAVA_SPRITE)).child((Component)FixedSpriteComponent.fixedSprite(LAVA_SPRITE)).configure(layout -> layout.positioning(Positioning.absolute((int)63, (int)4)).id("lava-bar"));
        rootComponent.child(Containers.verticalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)189)).child((Component)this.fuelGauge).child((Component)this.progressGauge).child((Component)this.invalidCross).child((Component)this.lavaBar).child((Component)Components.label((class_2561)class_2561.method_43471((String)"title.alloy-forgery.forge_controller")).color(ComponentUtils.getThemedValue(Color.ofRgb((int)0x3F3F3F), Color.WHITE)).positioning(Positioning.relative((int)50, (int)12))).child(Containers.horizontalFlow((Sizing)Sizing.fixed((int)26), (Sizing)Sizing.content()).child(Components.button((class_2561)class_2561.method_43473(), btn -> {
            this.allowSlotToggling = !this.allowSlotToggling;
            btn.tooltip((class_2561)class_2561.method_43471((String)("tooltip.alloy-forgery.slot_toggle_" + (this.allowSlotToggling ? "enable" : "disable"))));
        }).renderer((context, button, delta) -> {
            ComponentUtils.BUTTON_RENDERER.draw(context, button, delta);
            context.push().translate((float)button.method_46426(), (float)button.method_46427(), 0.0f);
            context.method_25290(class_1921::method_62277, ComponentUtils.textureID("slot_locks.png"), 4, 3, this.allowSlotToggling ? 10.0f : 0.0f, 0.0f, 10, 12, 20, 12);
            context.pop();
        }).tooltip((class_2561)class_2561.method_43471((String)"tooltip.alloy-forgery.slot_toggle_disable")).sizing(Sizing.fixed((int)18), Sizing.fixed((int)18))).horizontalAlignment(HorizontalAlignment.CENTER).positioning(Positioning.absolute((int)140, (int)75))).child(ComponentUtils.makeInputSlots(((AlloyForgeScreenHandler)this.method_17577()).getInputSlots(), 1, AlloyForgery.CONFIG::darkModeTheme, slot -> new BaseOwoHandledScreen.SlotComponent(this, slot.field_7874){

            public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
                this.didDraw = true;
            }
        }, ((AlloyForgeScreenHandler)this.field_2797)::isSlotDisabled).positioning(Positioning.absolute((int)42, (int)41))).surface((context, component) -> {
            class_2960 backgroundTexture = ComponentUtils.themedTextureID("forge_controller_base.png");
            context.push().translate((float)component.x(), (float)component.y(), 0.0f);
            context.method_25290(class_1921::method_62277, backgroundTexture, 0, 0, 0.0f, 0.0f, 176, 189, 176, 189);
            context.method_25290(class_1921::method_62277, ComponentUtils.themedTextureID("fuel_meter.png"), 5, 22, 0.0f, 0.0f, 22, 48, 44, 48);
            context.method_25290(class_1921::method_62277, ComponentUtils.textureID("forging_status.png"), 143, 21, 0.0f, 0.0f, 20, 22, 40, 22);
            context.pop();
        }).id("main-layout"));
        rootComponent.verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).surface(Surface.VANILLA_TRANSLUCENT);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.fuelGauge.visibleArea(PositionedRectangle.of((int)0, (int)(this.fuelGauge.height() - ((AlloyForgeScreenHandler)this.field_2797).getFuelProgress()), (Size)this.fuelGauge.fullSize()));
        this.progressGauge.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)this.progressGauge.width(), (int)((AlloyForgeScreenHandler)this.field_2797).getSmeltProgress()));
        this.lavaBar.horizontalSizing(Sizing.fixed((int)((AlloyForgeScreenHandler)this.field_2797).getLavaProgress()));
        int requiredTier = ((AlloyForgeScreenHandler)this.field_2797).getRequiredTierData();
        if (requiredTier <= -1) {
            this.invalidCross.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)0, (int)0)).tooltip(List.of());
        } else {
            this.invalidCross.resetVisibleArea().tooltip((class_2561)class_2561.method_43469((String)"tooltip.alloy-forgery.invalid_tier", (Object[])new Object[]{requiredTier}));
        }
    }

    protected void method_2380(class_332 context, int x, int y) {
        super.method_2380(context, x, y);
        if (this.allowSlotToggling && this.field_2787 instanceof ForgeInputSlot && ((AlloyForgeScreenHandler)this.field_2797).method_34255().method_7960() && !this.field_2787.method_7681() && !((AlloyForgeScreenHandler)this.field_2797).player().method_7325()) {
            context.push().translate(0.0f, 0.0f, (float)this.getLayerZOffset(BaseOwoHandledScreen.HandledScreenLayer.ITEM_TOOLTIP));
            if (((AlloyForgeScreenHandler)this.field_2797).isSlotDisabled(this.field_2787)) {
                context.method_51438(this.field_22793, DISABLED_SLOT_TEXT, x, y);
            } else {
                context.method_51438(this.field_22793, ENABLED_SLOT_TEXT, x, y);
            }
            context.pop();
        }
    }

    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        class_1657 player = ((AlloyForgeScreenHandler)this.field_2797).player();
        if (this.allowSlotToggling && slot instanceof ForgeInputSlot && !slot.method_7681() && !player.method_7325()) {
            if (actionType == class_1713.field_7790) {
                if (((AlloyForgeScreenHandler)this.field_2797).isSlotDisabled(slot)) {
                    this.setSlotEnabled(slot, true);
                } else {
                    this.setSlotEnabled(slot, false);
                }
            } else if (actionType == class_1713.field_7791) {
                class_1799 itemStack = player.method_31548().method_5438(button);
                if (((AlloyForgeScreenHandler)this.field_2797).isSlotDisabled(slot) && !itemStack.method_7960()) {
                    this.setSlotEnabled(slot, true);
                }
            }
        }
        super.method_2383(slot, slotId, button, actionType);
    }

    private void setSlotEnabled(class_1735 slot, boolean enabled) {
        AlloyForgeNetworking.CHANNEL.clientHandle().send((Record)new DisableSlotToggle(((AlloyForgeScreenHandler)this.field_2797).forge, (Integer)slot.method_34266(), (Boolean)(!enabled ? 1 : 0)));
        super.method_54590(slot.field_7874, ((AlloyForgeScreenHandler)this.field_2797).field_7763, enabled);
        float f = enabled ? 1.0f : 0.75f;
        ((AlloyForgeScreenHandler)this.field_2797).player().method_5783((class_3414)class_3417.field_15015.comp_349(), 0.4f, f);
    }

    public int rootX() {
        return this.field_2776;
    }

    public int rootY() {
        return this.field_2800;
    }
}

