/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.forges;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.utils.data.EndecDataLoader;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7923;

public class ForgeFuelDataLoader {
    public static final StructEndec<Pair<class_1792, ForgeFuelDefinition>> FUEL_ENTRY = StructEndecBuilder.of((StructField)MinecraftEndecs.ofRegistry((class_2378)class_7923.field_41178).fieldOf("item", Pair::first), (StructField)ForgeFuelDefinition.ENDEC.flatFieldOf(Pair::second), Pair::of);
    public static final class_2960 LOADER_ID = AlloyForgery.id("forge_fuel_loader");
    private static final Map<class_1792, ForgeFuelDefinition> REGISTRY = new HashMap<class_1792, ForgeFuelDefinition>();

    public static void init() {
        EndecDataLoader.builder("alloy_forge_fuels", FUEL_ENTRY.listOf().structOf("fuels")).create(LOADER_ID, class_3264.field_14190, (data, manager, profiler) -> data.values().stream().flatMap(Collection::stream).forEach(entry -> ForgeFuelDataLoader.register((class_1792)entry.first(), (ForgeFuelDefinition)entry.second())));
    }

    public static void clear() {
        REGISTRY.clear();
    }

    public static ForgeFuelDefinition getFuelForItem(class_1792 item) {
        return REGISTRY.getOrDefault(item, ForgeFuelDefinition.EMPTY);
    }

    public static boolean hasFuel(class_1792 item) {
        return REGISTRY.containsKey(item);
    }

    public static void register(class_1792 item, ForgeFuelDefinition fuel) {
        REGISTRY.put(item, fuel);
    }

    public record ForgeFuelDefinition(int fuel, class_1792 returnType) {
        public static final ForgeFuelDefinition EMPTY = new ForgeFuelDefinition(0, null);
        public static StructEndec<ForgeFuelDefinition> ENDEC = StructEndecBuilder.of((StructField)Endec.INT.fieldOf("fuel", ForgeFuelDefinition::fuel), (StructField)MinecraftEndecs.ofRegistry((class_2378)class_7923.field_41178).optionalFieldOf("return_item", ForgeFuelDefinition::returnType, () -> null), ForgeFuelDefinition::new);

        public boolean hasReturnType() {
            return this.returnType != null;
        }
    }
}

