/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.forges;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.forges.ForgeRegistry;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.alloyforgery.utils.RecipeInjector;
import io.wispforest.alloyforgery.utils.data.EndecableModDataLoader;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.gson.GsonEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.registration.ComplexRegistryAction;
import io.wispforest.owo.registration.RegistryHelper;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public record ForgeDefinition(class_2248 material, ImmutableList<class_2248> additionalMaterials, boolean blockEntity) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Endec<ForgeDefinition> FORGE_DEFINITION = MinecraftEndecs.IDENTIFIER.xmap(identifier -> ForgeRegistry.getForgeDefinition(identifier).orElseThrow(() -> new IllegalStateException("Unable to locate ForgerDefinition with Identifier: [ID: " + String.valueOf(identifier) + "]")), forgeDefinition -> forgeDefinition.id().orElseThrow(() -> new IllegalStateException("A Given forge Definition was not found within the ForgeRegistry!")));
    @ApiStatus.Internal
    public static final Map<class_2960, ForgeTier> legacyForgeDefinitionIdToTier = new HashMap<class_2960, ForgeTier>();
    private static final String RECIPE_PATTERN = "{\n    \"type\": \"minecraft:crafting_shaped\",\n    \"pattern\": [\n        \"###\",\n        \"#B#\",\n        \"###\"\n    ],\n    \"key\": {\n        \"#\": \"{material}\",\n        \"B\": \"minecraft:blast_furnace\"\n    },\n    \"result\": {\n        \"id\": \"{controller}\",\n        \"count\": 1\n    }\n}\n";

    public ForgeDefinition(class_2248 material, ImmutableList<class_2248> additionalMaterials) {
        this(material, additionalMaterials, false);
    }

    public Optional<class_2960> id() {
        return ForgeRegistry.getId(this);
    }

    @Deprecated
    @ApiStatus.Internal
    public static void loadAndEnqueue(class_2960 id, JsonObject json) {
        LOGGER.warn("A given Forge Definition '{}' has been loaded though a deprecated manor, please bug the author to switch over to the new system.", (Object)id);
        int forgeTier = class_3518.method_15260((JsonObject)json, (String)"tier");
        float speedMultiplier = class_3518.method_15277((JsonObject)json, (String)"speed_multiplier", (float)1.0f);
        int fuelCapacity = class_3518.method_15282((JsonObject)json, (String)"fuel_capacity", (int)48000);
        ForgeTier tier = new ForgeTier(id, forgeTier, speedMultiplier, fuelCapacity, Optional.empty());
        legacyForgeDefinitionIdToTier.put(id, tier);
        class_2960 mainMaterialId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"material"));
        ArrayList<class_2960> additionalMaterialIds = new ArrayList<class_2960>();
        class_3518.method_15292((JsonObject)json, (String)"additional_materials", (JsonArray)new JsonArray()).forEach(jsonElement -> additionalMaterialIds.add(class_2960.method_12829((String)jsonElement.getAsString())));
        ForgeDefinition.loadAndEnqueue(id, new RawForgeDefinition(mainMaterialId, additionalMaterialIds, false));
    }

    @ApiStatus.Internal
    private static void loadAndEnqueue(class_2960 id, RawForgeDefinition rawForgeDefinition) {
        ComplexRegistryAction action = ComplexRegistryAction.Builder.create(() -> {
            class_2248 mainMaterial = (class_2248)class_7923.field_41175.method_63535(rawForgeDefinition.materialId());
            ImmutableList.Builder additionalMaterialsBuilder = new ImmutableList.Builder();
            rawForgeDefinition.additionalMaterialIds().forEach(identifier -> additionalMaterialsBuilder.add((Object)((class_2248)class_7923.field_41175.method_63535(identifier))));
            ForgeDefinition definition = new ForgeDefinition(mainMaterial, (ImmutableList<class_2248>)additionalMaterialsBuilder.build());
            ForgeRegistry.registerDefinition(id, definition);
        }).entries(rawForgeDefinition.blockIds()).build();
        RegistryHelper.get((class_2378)class_7923.field_41175).runWhenPresent(action);
    }

    public boolean isBlockValid(class_2248 block) {
        return block == this.material || this.additionalMaterials.contains((Object)block);
    }

    public JsonElement generateRecipe(class_2960 id) {
        String recipe = RECIPE_PATTERN.replace("{material}", class_7923.field_41178.method_10221((Object)this.material.method_8389()).toString());
        recipe = recipe.replace("{controller}", class_7923.field_41178.method_10221((Object)ForgeRegistry.getControllerBlock(id).get().method_8389()).toString());
        return (JsonElement)ForgeRegistry.GSON.fromJson(recipe, JsonObject.class);
    }

    public static void runDataLoaders() {
        EndecableModDataLoader.of(AlloyForgery.id("old_forge_definition_loader"), "alloy_forges", GsonEndec.INSTANCE.xmap(JsonElement::getAsJsonObject, jsonObject -> jsonObject), ForgeDefinition::loadAndEnqueue).load();
        EndecableModDataLoader.of(AlloyForgery.id("forge_definition_loader"), "alloy_forge/controller", RawForgeDefinition.ENDEC, ForgeDefinition::loadAndEnqueue).load();
    }

    public static void injectRecipeAdditions() {
        RecipeInjector.ADD_RECIPES.register(instance -> {
            for (Map.Entry<class_2960, ForgeDefinition> forgeEntry : ForgeRegistry.getForgeEntries()) {
                class_2960 id = forgeEntry.getKey();
                try {
                    class_1869 recipe = (class_1869)((Pair)class_1865.field_9035.method_53736().codec().decode((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)instance.lookup()), (Object)forgeEntry.getValue().generateRecipe(id)).getOrThrow(string -> new IllegalStateException("Unable to generate recipe for given ForgeDefinition [" + String.valueOf(id) + "]: " + string))).getFirst();
                    instance.addRecipe(id.method_48331("_recipe"), recipe);
                }
                catch (Throwable e) {
                    LOGGER.error("{} recipe had a issue!", (Object)id, (Object)e);
                }
            }
        });
    }

    @Override
    public String toString() {
        return "ForgeDefinition{material=" + String.valueOf(this.material) + ", additionalMaterials=" + String.valueOf(this.additionalMaterials) + "}";
    }

    private record RawForgeDefinition(class_2960 materialId, List<class_2960> additionalMaterialIds, boolean isBlockEntity) {
        public static final StructEndec<RawForgeDefinition> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("material", RawForgeDefinition::materialId), (StructField)MinecraftEndecs.IDENTIFIER.listOf().optionalFieldOf("additional_materials", RawForgeDefinition::additionalMaterialIds, List.of()), (StructField)Endec.BOOLEAN.optionalFieldOf("is_block_entity", RawForgeDefinition::isBlockEntity, (Object)false), RawForgeDefinition::new);

        public List<class_2960> blockIds() {
            ArrayList<class_2960> list = new ArrayList<class_2960>(this.additionalMaterialIds);
            list.addFirst(this.materialId);
            return list;
        }
    }
}

