/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.PowerConfig;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class Config {
    public final Common common;
    public final EnableMap enableMap;
    public final PowerMap powerMap;
    public final AcceptableEnchantmentsMap acceptableEnchantmentsMap;

    public Config(ForgeConfigSpec.Builder builder) {
        this.common = new Common(builder);
        this.enableMap = new EnableMap(builder);
        this.powerMap = new PowerMap(builder);
        this.acceptableEnchantmentsMap = new AcceptableEnchantmentsMap(builder);
    }

    public boolean debug() {
        return !FMLEnvironment.production || (Boolean)this.common.debug.get() != false;
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue netherTop;
        private final ForgeConfigSpec.BooleanValue debug;
        public final ForgeConfigSpec.BooleanValue noEnergy;
        public final ForgeConfigSpec.BooleanValue convertDeepslateOres;
        public final ForgeConfigSpec.DoubleValue sfqEnergy;
        public final ForgeConfigSpec.BooleanValue removeCommonMaterialsByCD;
        public final ForgeConfigSpec.BooleanValue reduceMarkerGuideLineIfPlayerIsFar;
        public final ForgeConfigSpec.BooleanValue removeFrameAfterQuarryIsRemoved;
        public final ForgeConfigSpec.BooleanValue allowWorkInClaimedChunkByFBTChunks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> spawnerBlackList;
        public final ForgeConfigSpec.IntValue chunkDestroyerLimit;
        public final ForgeConfigSpec.IntValue flexMarkerMaxDistance;

        public Common(ForgeConfigSpec.Builder builder) {
            boolean inDev = !FMLEnvironment.production;
            builder.comment("QuarryPlus Setting").push("common");
            this.netherTop = builder.comment("The top of Nether").defineInRange("netherTop", inDev ? 128 : 127, -256, 256);
            this.debug = builder.comment("debug mode").define("debug", inDev);
            this.noEnergy = builder.comment("no energy").define("noEnergy", false);
            this.convertDeepslateOres = builder.comment("Whether quarry converts deepslate ore to normal ore.").define("convertDeepslateOres", false);
            List<String> disabledEntities = List.of("minecraft:ender_dragon", "minecraft:wither", "minecraft:area_effect_cloud", "minecraft:item", "minecraft:player");
            this.spawnerBlackList = builder.comment("Spawner Controller Blacklist").defineListAllowEmpty(List.of("spawnerBlacklist"), () -> disabledEntities, s -> s instanceof String);
            this.sfqEnergy = builder.comment("The amount of energy[FE] that Solid Fuel Quarry generates in a tick.").defineInRange("sfqEnergy", 2.0, 0.0, 100.0);
            this.removeCommonMaterialsByCD = builder.comment("Remove common materials(Stone, Dirt, Grass, Sand) obtained by Chunk Destroyer").define("removeCommonMaterialsByCD", true);
            this.reduceMarkerGuideLineIfPlayerIsFar = builder.comment("Remove MarkerPlus guide line if player is too far from the marker.").define("reduceMarkerGuideLineIfPlayerIsFar", false);
            this.removeFrameAfterQuarryIsRemoved = builder.comment("Remove adjacent frames when quarry is removed.").define("removeFrameAfterQuarryIsRemoved", false);
            this.allowWorkInClaimedChunkByFBTChunks = builder.comment("Allow quarries to work in claimed chunk(FTB Chunks).").define("allowWorkInClaimedChunkByFBTChunks", false);
            this.chunkDestroyerLimit = builder.comment("The range limit(unit: blocks) of ChunkDestroyer. Set -1 or 0 to remove limitation.").defineInRange("chunkDestroyerLimit", -1, -1, Integer.MAX_VALUE);
            this.flexMarkerMaxDistance = builder.comment("The max distance(unit: blocks) Flexible Marker can reach").defineInRange("flexMarkerMaxDistance", 256, 16, 4096);
            builder.pop();
        }
    }

    public static class EnableMap {
        private final Map<String, BooleanSupplier> machinesMap;

        public EnableMap(ForgeConfigSpec.Builder builder) {
            builder.comment("QuarryPlus Machines. Set true to enable machine or item.").push("machines");
            JsonObject defaultConfig = GsonHelper.parse((Reader)new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream("/machine_default.json"), "Content in Jar must not be absent.")));
            this.machinesMap = defaultConfig.entrySet().stream().map(e -> Map.entry(new ResourceLocation("quarryplus", (String)e.getKey()), Holder.EnableOrNot.valueOf(((JsonElement)e.getValue()).getAsString()))).map(e -> new Holder.EntryConditionHolder((ResourceLocation)e.getKey(), (Holder.EnableOrNot)((Object)((Object)e.getValue())))).filter(Holder.EntryConditionHolder::configurable).sorted(Comparator.comparing(Holder.EntryConditionHolder::path)).map(n -> Map.entry(n.path(), builder.define(n.path(), !FMLEnvironment.production || n.condition().on()))).collect(Collectors.toMap(Map.Entry::getKey, e -> () -> (Boolean)((ForgeConfigSpec.BooleanValue)e.getValue()).get()));
            builder.pop();
        }

        public boolean enabled(String s) {
            return Optional.ofNullable(this.machinesMap.get(s)).map(BooleanSupplier::getAsBoolean).or(() -> Holder.conditionHolders().stream().filter(h -> h.path().equals(s)).findFirst().map(Holder.EntryConditionHolder::condition).map(Holder.EnableOrNot::on)).orElse(Boolean.FALSE);
        }

        public boolean enabled(@Nullable ResourceLocation location) {
            if (location == null) {
                return false;
            }
            return this.enabled(location.getPath());
        }

        public void set(String name, boolean value) {
            this.machinesMap.put(name, () -> value);
        }
    }

    public static class PowerMap {
        @VisibleForTesting
        final Map<String, Map<String, ForgeConfigSpec.DoubleValue>> map = new HashMap<String, Map<String, ForgeConfigSpec.DoubleValue>>();

        PowerMap(ForgeConfigSpec.Builder builder) {
            builder.comment("Power settings of each machines").push("powers");
            JsonObject defaultConfig = GsonHelper.parse((Reader)new InputStreamReader(Objects.requireNonNull(PowerMap.class.getResourceAsStream("/power_default.json"), "Content in Jar must not be absent.")));
            List<KeyPair> valuesFromJson = PowerMap.getKeys(defaultConfig);
            Set keys = valuesFromJson.stream().map(KeyPair::key).collect(Collectors.toSet());
            Stream valuesNotInJson = PowerConfig.getAllMethods().flatMap(m -> Stream.of("quarry", "solid_fuel_quarry", "adv_quarry").filter(name -> !keys.contains(new Key((String)name, m.getName()))).map(name -> new KeyPair(new Key((String)name, m.getName()), PowerMap.getDefaultValue(m))));
            Stream.concat(valuesFromJson.stream(), valuesNotInJson).collect(Collectors.groupingBy(KeyPair::machineName)).entrySet().stream().map(e -> {
                String key = (String)e.getKey();
                builder.push(key);
                Map<String, ForgeConfigSpec.DoubleValue> m = ((List)e.getValue()).stream().map(keyPair -> Map.entry(keyPair.key().configName(), builder.defineInRange(keyPair.key().configName(), keyPair.value(), 0.0, 1.0E9))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                builder.pop();
                return Map.entry(key, m);
            }).forEach(e -> this.map.put((String)e.getKey(), (Map)e.getValue()));
            builder.pop();
        }

        public OptionalDouble get(String machineName, String configName) {
            return Optional.ofNullable(this.map.get(machineName)).flatMap(m -> Optional.ofNullable((ForgeConfigSpec.DoubleValue)m.get(configName))).map(ForgeConfigSpec.ConfigValue::get).map(OptionalDouble::of).orElse(OptionalDouble.empty());
        }

        public boolean has(String machineName) {
            return this.map.containsKey(machineName);
        }

        private static double getDefaultValue(Method method) {
            try {
                Object value = method.invoke((Object)PowerConfig.DEFAULT, new Object[0]);
                if (value instanceof Long) {
                    Long aLong = (Long)value;
                    return aLong.doubleValue() / 1.0E9;
                }
                if (value instanceof Double) {
                    Double aDouble = (Double)value;
                    return aDouble;
                }
                throw new IllegalStateException("Non expected value was returned in executing %s. value=%s".formatted(method, value));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        private static List<KeyPair> getKeys(JsonObject object) {
            return object.keySet().stream().flatMap(machineName -> object.getAsJsonObject(machineName).entrySet().stream().map(e -> new KeyPair(new Key((String)machineName, (String)e.getKey()), ((JsonElement)e.getValue()).getAsDouble()))).toList();
        }

        private record KeyPair(Key key, double value) {
            String machineName() {
                return this.key().machineName();
            }
        }

        private record Key(String machineName, String configName) {
        }
    }

    public static class AcceptableEnchantmentsMap {
        @VisibleForTesting
        final Map<String, ForgeConfigSpec.ConfigValue<List<? extends String>>> enchantmentsMap;

        public AcceptableEnchantmentsMap(ForgeConfigSpec.Builder builder) {
            builder.comment("Enchantments. Defines enchantments machines can accept.").push("enchantments");
            this.enchantmentsMap = AcceptableEnchantmentsMap.getTargets().stream().map(e -> Map.entry(((ResourceLocation)e.getKey()).getPath(), builder.defineListAllowEmpty(List.of(((ResourceLocation)e.getKey()).getPath()), e::getValue, o -> {
                String s;
                return o instanceof String && ResourceLocation.isValidResourceLocation((String)(s = (String)o));
            }))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        @NotNull
        private static List<Map.Entry<ResourceLocation, List<String>>> getTargets() {
            List<String> vanillaAllEnchantments = List.of("minecraft:efficiency", "minecraft:unbreaking", "minecraft:fortune", "minecraft:silk_touch");
            List<String> miniQuarryEnchantments = List.of("minecraft:efficiency", "minecraft:unbreaking");
            List<String> pumpEnchantments = List.of("minecraft:efficiency", "minecraft:unbreaking", "minecraft:fortune");
            return List.of(Map.entry(new ResourceLocation("quarryplus", "quarry"), vanillaAllEnchantments), Map.entry(new ResourceLocation("quarryplus", "adv_quarry"), vanillaAllEnchantments), Map.entry(new ResourceLocation("quarryplus", "mini_quarry"), miniQuarryEnchantments), Map.entry(new ResourceLocation("quarryplus", "adv_pump"), pumpEnchantments));
        }

        public Set<Enchantment> getAllowedEnchantments(ResourceLocation machineName) {
            if (machineName == null) {
                return Set.of();
            }
            return Optional.ofNullable(this.enchantmentsMap.get(machineName.getPath())).map(ForgeConfigSpec.ConfigValue::get).orElseGet(List::of).stream().map(ResourceLocation::new).filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).containsKey(arg_0)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0)).collect(Collectors.toSet());
        }
    }
}

