/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.EnchantableItem;
import com.yogpc.qp.machines.EnchantmentLevel;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

class MoverRecipeCategory
implements IRecipeCategory<MoverRecipe> {
    public static final RecipeType<MoverRecipe> RECIPE_TYPE = RecipeType.create((String)"quarryplus", (String)"quarryplus.enchantmover", MoverRecipe.class);
    private static final ResourceLocation backGround = new ResourceLocation("quarryplus", "textures/gui/mover_jei.png");
    private static final int xOff = 0;
    private static final int yOff = 0;
    private final IGuiHelper helper;
    private final List<ItemStack> pickaxes;

    public MoverRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.pickaxes = List.of(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), new ItemStack((ItemLike)Items.NETHERITE_PICKAXE));
    }

    public RecipeType<MoverRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public ResourceLocation getUid() {
        return RECIPE_TYPE.getUid();
    }

    public Class<? extends MoverRecipe> getRecipeClass() {
        return RECIPE_TYPE.getRecipeClass();
    }

    public Component getTitle() {
        return Holder.BLOCK_MOVER.getName();
    }

    public IDrawable getBackground() {
        return this.helper.createDrawable(backGround, 0, 0, 167, 76);
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Holder.BLOCK_MOVER));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MoverRecipe recipe, IFocusGroup focuses) {
        List<Pair<Enchantment, ItemStack>> input = recipe.makeInput(this.pickaxes);
        List<ItemStack> output = input.stream().map(Pair::getKey).map(recipe::makeOutput).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 31).addItemStacks(input.stream().map(Pair::getValue).toList());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 148, 31).addItemStacks(output);
    }

    public void draw(MoverRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        List<Enchantment> enchantments = recipe.item.acceptEnchantments().stream().map(e -> new EnchantmentLevel((Enchantment)e, 1)).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).map(EnchantmentLevel::enchantment).toList();
        for (int i = 0; i < enchantments.size(); ++i) {
            TranslatableComponent text = new TranslatableComponent(enchantments.get(i).getDescriptionId());
            Minecraft.getInstance().font.draw(stack, (Component)text, 36.0f, (float)(6 + 10 * i), 0x404040);
        }
    }

    static List<MoverRecipe> recipes() {
        return ForgeRegistries.ITEMS.getValues().stream().filter(i -> i instanceof EnchantableItem).map(i -> new MoverRecipe((EnchantableItem)i, new ItemStack((ItemLike)i))).toList();
    }

    record MoverRecipe(EnchantableItem item, ItemStack stack) {
        List<Pair<Enchantment, ItemStack>> makeInput(List<ItemStack> pickaxes) {
            return this.item.acceptEnchantments().stream().flatMap(e -> pickaxes.stream().map(ItemStack::copy).peek(i -> i.enchant(e, e.getMaxLevel())).map(i -> Pair.of((Object)e, (Object)i))).toList();
        }

        ItemStack makeOutput(Enchantment enchantment) {
            ItemStack s = this.stack.copy();
            s.enchant(enchantment, enchantment.getMaxLevel());
            return s;
        }
    }
}

