/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Area(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Direction direction) implements Serializable
{
    private static final long serialVersionUID = 1L;

    public Area {
        if (minX > maxX) {
            throw new IllegalArgumentException("MinX(%d) must be less than or equal to MaxX(%d)".formatted(minX, maxX));
        }
        if (minY > maxY) {
            throw new IllegalArgumentException("MinY(%d) must be less than or equal to MaxY(%d)".formatted(minY, maxY));
        }
        if (minZ > maxZ) {
            throw new IllegalArgumentException("MinZ(%d) must be less than or equal to MaxZ(%d)".formatted(minZ, maxZ));
        }
    }

    public Area(Vec3i pos1, Vec3i pos2, Direction direction) {
        this(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()), Math.min(pos1.getZ(), pos2.getZ()), Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()), Math.max(pos1.getZ(), pos2.getZ()), direction);
    }

    public Area assureY(int minSpaceY) {
        int space = this.maxY - this.minY;
        if (space >= minSpaceY) {
            return this;
        }
        return new Area(this.minX, this.minY, this.minZ, this.maxX, this.minY + minSpaceY, this.maxZ, this.direction);
    }

    public Area aboveY(int minY) {
        if (this.minY < minY && minY <= this.maxY) {
            return new Area(this.minX, minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.direction);
        }
        return this;
    }

    public Area shrink(int x, int y, int z) {
        int x1 = this.minX + x;
        int x2 = this.maxX - x;
        int y1 = this.minY + y;
        int y2 = this.maxY - y;
        int z1 = this.minZ + z;
        int z2 = this.maxZ - z;
        return new Area(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2), this.direction);
    }

    public boolean isInAreaIgnoreY(Vec3i vec3i) {
        return this.minX < vec3i.getX() && vec3i.getX() < this.maxX && this.minZ < vec3i.getZ() && vec3i.getZ() < this.maxZ;
    }

    public boolean isRangeInLimit(int limit, boolean isAdvQuarry) {
        if (limit <= 0) {
            return true;
        }
        int offset = isAdvQuarry ? 2 : 0;
        return this.maxX - this.minX - offset <= limit && this.maxZ - this.minZ - offset <= limit;
    }

    public int sizeOfEachY() {
        return (this.maxX() - this.minX()) * (this.maxZ() - this.minZ());
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("minX", this.minX);
        tag.putInt("minY", this.minY);
        tag.putInt("minZ", this.minZ);
        tag.putInt("maxX", this.maxX);
        tag.putInt("maxY", this.maxY);
        tag.putInt("maxZ", this.maxZ);
        tag.putString("direction", this.direction.getName());
        return tag;
    }

    public static Optional<Area> fromNBT(@Nullable CompoundTag tag) {
        if (tag == null || tag.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Area(tag.getInt("minX"), tag.getInt("minY"), tag.getInt("minZ"), tag.getInt("maxX"), tag.getInt("maxY"), tag.getInt("maxZ"), Direction.byName((String)tag.getString("direction"))));
    }

    @NotNull
    public static Stream<BlockPos> getFramePosStream(@NotNull Area area) {
        return Stream.of(Area.makeSquare(area, area.minY()), Area.makePole(area, area.minY() + 1, area.maxY()), Area.makeSquare(area, area.maxY())).flatMap(Function.identity());
    }

    static IntStream to(int first, int endInclusive) {
        if (first < endInclusive) {
            return IntStream.rangeClosed(first, endInclusive);
        }
        if (first > endInclusive) {
            return IntStream.iterate(first, i -> i >= endInclusive, i -> i - 1);
        }
        return IntStream.of(first);
    }

    static Stream<BlockPos> makeSquare(Area area, int y) {
        return Stream.of(Area.to(area.minX(), area.maxX()).mapToObj(x -> new BlockPos(x, y, area.minZ())), Area.to(area.minZ(), area.maxZ()).mapToObj(z -> new BlockPos(area.maxX(), y, z)), Area.to(area.maxX(), area.minX()).mapToObj(x -> new BlockPos(x, y, area.maxZ())), Area.to(area.maxZ(), area.minZ()).mapToObj(z -> new BlockPos(area.minX(), y, z))).flatMap(Function.identity());
    }

    static Stream<BlockPos> makePole(Area area, int yMin, int yMax) {
        return Area.to(yMin, yMax).boxed().flatMap(y -> Stream.of(new BlockPos(area.minX(), y.intValue(), area.minZ()), new BlockPos(area.maxX(), y.intValue(), area.minZ()), new BlockPos(area.maxX(), y.intValue(), area.maxZ()), new BlockPos(area.minX(), y.intValue(), area.maxZ())));
    }
}

