/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.ItemKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public record ItemConverter(List<Map.Entry<Predicate<ItemKey>, Function<ItemKey, ItemKey>>> conversionMap) {
    public ItemConverter(Map<ItemKey, ItemKey> map) {
        this(map.entrySet().stream().map((? super T e) -> {
            Predicate predicate = Predicate.isEqual(e.getKey());
            Function<ItemKey, ItemKey> converter = i -> (ItemKey)e.getValue();
            return Map.entry(predicate, converter);
        }).toList());
    }

    public ItemStack map(ItemStack before) {
        if (this.conversionMap().isEmpty()) {
            return before;
        }
        ItemKey key = new ItemKey(before);
        return this.conversionMap().stream().filter(e -> ((Predicate)e.getKey()).test(key)).findFirst().map(Map.Entry::getValue).map((? super T f) -> (ItemKey)f.apply(key)).map((? super T k) -> k.toStack(before.getCount())).orElse(before);
    }

    public ItemConverter combined(ItemConverter other) {
        ArrayList<Map.Entry<Predicate<ItemKey>, Function<ItemKey, ItemKey>>> newList = new ArrayList<Map.Entry<Predicate<ItemKey>, Function<ItemKey, ItemKey>>>(this.conversionMap());
        newList.addAll(other.conversionMap());
        return new ItemConverter(newList);
    }

    public static ItemConverter defaultConverter() {
        if (((Boolean)QuarryPlus.config.common.convertDeepslateOres.get()).booleanValue()) {
            return ItemConverter.deepslateConverter();
        }
        return new ItemConverter(List.of());
    }

    public static ItemConverter deepslateConverter() {
        Predicate<ItemKey> predicate = i -> {
            String path = i.getId().getPath();
            return path.contains("deepslate") && path.contains("ore");
        };
        Function<ItemKey, ItemKey> function = i -> {
            String newPath = i.getId().getPath().replace("deepslate_", "").replace("_deepslate", "");
            ResourceLocation id = new ResourceLocation(i.getId().getNamespace(), newPath);
            if (ForgeRegistries.ITEMS.containsKey(id)) {
                return new ItemKey((Item)ForgeRegistries.ITEMS.getValue(id), i.nbt());
            }
            return null;
        };
        return new ItemConverter(List.of(Pair.of(predicate, function)));
    }

    public static ItemConverter advQuarryConverter() {
        if (!((Boolean)QuarryPlus.config.common.removeCommonMaterialsByCD.get()).booleanValue()) {
            return new ItemConverter(List.of());
        }
        Function<ItemKey, ItemKey> function = itemKey -> new ItemKey(ItemStack.EMPTY);
        return new ItemConverter(Stream.of(ItemConverter.tagPredicate((TagKey<Item>)Tags.Items.STONE), ItemConverter.tagPredicate((TagKey<Item>)Tags.Items.COBBLESTONE), ItemConverter.itemPredicate(Items.DIRT), ItemConverter.itemPredicate(Items.GRASS_BLOCK), ItemConverter.blockTagPredicate((TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD), ItemConverter.blockTagPredicate((TagKey<Block>)BlockTags.BASE_STONE_NETHER), ItemConverter.tagPredicate((TagKey<Item>)Tags.Items.SANDSTONE)).map((? super T p) -> Map.entry(p, function)).toList());
    }

    static Predicate<ItemKey> tagPredicate(TagKey<Item> tag) {
        return itemKey -> itemKey.toStack(1).is(tag);
    }

    static Predicate<ItemKey> blockTagPredicate(TagKey<Block> tag) {
        return itemKey -> {
            BlockItem blockItem;
            Item patt4379$temp = itemKey.item();
            return patt4379$temp instanceof BlockItem && (blockItem = (BlockItem)patt4379$temp).getBlock().defaultBlockState().is(tag);
        };
    }

    static Predicate<ItemKey> itemPredicate(Item item) {
        return itemKey -> itemKey.item() == item;
    }
}

