/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public record ItemKey(Item item, @Nullable CompoundTag nbt) {
    public ItemKey(ItemStack stack) {
        this(stack.getItem(), stack.getTag());
    }

    public CompoundTag createNbt(long itemCount) {
        CompoundTag tag = new CompoundTag();
        tag.putString("item", this.getId().toString());
        if (this.nbt != null) {
            tag.put("tag", (Tag)this.nbt);
        }
        tag.putLong("count", itemCount);
        return tag;
    }

    static ItemKey fromNbt(CompoundTag tag) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.getString("item")));
        CompoundTag nbt = tag.contains("tag") ? tag.getCompound("tag") : null;
        return new ItemKey(item, nbt);
    }

    public ItemStack toStack(int count) {
        ItemStack stack = new ItemStack((ItemLike)this.item, count);
        stack.setTag(this.nbt);
        return stack;
    }

    public ResourceLocation getId() {
        return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item);
    }
}

