/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.google.common.collect.Iterators;
import com.yogpc.qp.machines.FluidKey;
import com.yogpc.qp.machines.ItemKey;
import com.yogpc.qp.utils.MapMulti;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class MachineStorage {
    protected Map<ItemKey, Long> itemMap = new LinkedHashMap<ItemKey, Long>();
    protected Map<FluidKey, Long> fluidMap = new LinkedHashMap<FluidKey, Long>();
    protected LazyOptional<IItemHandler> itemHandler;
    protected LazyOptional<IFluidHandler> fluidHandler;
    private static final int MAX_TRANSFER = 4;
    @VisibleForTesting
    static final List<Direction> INSERT_ORDER = List.of(Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST, Direction.DOWN, Direction.UP);

    public MachineStorage() {
        this.setHandler();
    }

    protected void setHandler() {
        this.itemHandler = LazyOptional.of(() -> new StorageItemHandler());
        this.fluidHandler = LazyOptional.of(() -> new StorageFluidHandler());
    }

    public void addItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        ItemKey key = new ItemKey(stack);
        this.itemMap.merge(key, Long.valueOf(stack.getCount()), Long::sum);
    }

    public void addFluid(ItemStack bucketItem) {
        FluidUtil.getFluidContained((ItemStack)bucketItem).ifPresent(f -> {
            FluidKey key = new FluidKey((FluidStack)f);
            this.fluidMap.merge(key, Long.valueOf(f.getAmount()), Long::sum);
        });
    }

    public void addFluid(Fluid fluid, long amount) {
        FluidKey key = new FluidKey(fluid, null);
        this.fluidMap.merge(key, amount, (l1, l2) -> {
            long a = l1 + l2;
            if (a > 0L) {
                return a;
            }
            return null;
        });
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        ListTag itemTag = new ListTag();
        this.itemMap.forEach((itemKey, count) -> itemTag.add((Object)itemKey.createNbt((long)count)));
        ListTag fluidTag = new ListTag();
        this.fluidMap.forEach((fluidKey, amount) -> fluidTag.add((Object)fluidKey.createNbt((long)amount)));
        tag.put("items", (Tag)itemTag);
        tag.put("fluids", (Tag)fluidTag);
        return tag;
    }

    public void readNbt(CompoundTag tag) {
        ListTag itemTag = tag.getList("items", 10);
        this.itemMap = itemTag.stream().mapMulti(MapMulti.cast(CompoundTag.class)).collect(Collectors.toMap(ItemKey::fromNbt, n -> n.getLong("count")));
        ListTag fluidTag = tag.getList("fluids", 10);
        this.fluidMap = fluidTag.stream().mapMulti(MapMulti.cast(CompoundTag.class)).collect(Collectors.toMap(FluidKey::fromNbt, n -> n.getLong("amount")));
    }

    public Map<FluidKey, Long> getFluidMap() {
        return Map.copyOf(this.fluidMap);
    }

    private void putFluid(FluidKey key, long amount) {
        if (amount <= 0L) {
            this.fluidMap.remove(key);
        } else {
            this.fluidMap.put(key, amount);
        }
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> passItems() {
        return (world, pos, state, blockEntity) -> {
            MachineStorage storage = ((HasStorage)blockEntity).getStorage();
            int count = 0;
            for (Direction direction : INSERT_ORDER) {
                Optional<BlockEntity> destination = Optional.ofNullable(world.getBlockEntity(pos.relative(direction)));
                Optional optional = destination.flatMap(d -> d.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.getOpposite()).resolve());
                if (!optional.isPresent()) continue;
                IItemHandler handler = (IItemHandler)optional.get();
                ArrayList<Map.Entry<ItemKey, Long>> itemMap = new ArrayList<Map.Entry<ItemKey, Long>>(storage.itemMap.entrySet());
                for (Map.Entry<ItemKey, Long> entry : itemMap) {
                    long beforeCount = entry.getValue();
                    boolean flag = true;
                    while (beforeCount > 0L && flag) {
                        ItemStack rest;
                        int itemCount = (int)Math.min((long)entry.getKey().toStack(1).getMaxStackSize(), beforeCount);
                        if (itemCount != (rest = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)entry.getKey().toStack(itemCount), (boolean)false)).getCount()) {
                            long remain;
                            beforeCount = remain = beforeCount - (long)(itemCount - rest.getCount());
                            if (remain > 0L) {
                                storage.itemMap.put(entry.getKey(), remain);
                            } else {
                                storage.itemMap.remove(entry.getKey());
                            }
                            if (++count < 4) continue;
                            return;
                        }
                        flag = false;
                    }
                }
            }
        };
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> passFluid() {
        return (world, pos, state, blockEntity) -> {
            MachineStorage storage = ((HasStorage)blockEntity).getStorage();
            int count = 0;
            for (Direction direction : INSERT_ORDER) {
                BlockPos destPos = pos.relative(direction);
                Optional optional = Optional.ofNullable(world.getBlockEntity(destPos)).flatMap(d -> d.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.getOpposite()).resolve());
                if (!optional.isPresent()) continue;
                IFluidHandler handler = (IFluidHandler)optional.get();
                ArrayList<Map.Entry<FluidKey, Long>> fluidMap = new ArrayList<Map.Entry<FluidKey, Long>>(storage.getFluidMap().entrySet());
                for (Map.Entry<FluidKey, Long> entry : fluidMap) {
                    int filled = handler.fill(entry.getKey().toStack((int)Math.min(entry.getValue(), Integer.MAX_VALUE)), IFluidHandler.FluidAction.EXECUTE);
                    if (filled <= 0) continue;
                    storage.putFluid(entry.getKey(), entry.getValue() - (long)filled);
                    if (++count <= 4) continue;
                    return;
                }
            }
        };
    }

    public static interface HasStorage {
        public MachineStorage getStorage();
    }

    private final class StorageFluidHandler
    implements IFluidHandler {
        private StorageFluidHandler() {
        }

        public int getTanks() {
            return MachineStorage.this.fluidMap.size();
        }

        private Optional<Map.Entry<FluidKey, Long>> getByIndex(int index) {
            if (0 <= index && index < this.getTanks()) {
                return Optional.of((Map.Entry)Iterators.get(MachineStorage.this.fluidMap.entrySet().iterator(), (int)index));
            }
            return Optional.empty();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.getByIndex(tank).map(e -> ((FluidKey)e.getKey()).toStack((int)Math.min((Long)e.getValue(), Integer.MAX_VALUE))).orElse(FluidStack.EMPTY);
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidKey key = new FluidKey(resource);
            return Optional.ofNullable(MachineStorage.this.fluidMap.get(key)).map(l -> Map.entry(key, l)).map(e -> this.drainInternal((Map.Entry<FluidKey, Long>)e, resource.getAmount(), action)).orElse(FluidStack.EMPTY);
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            Iterator<Map.Entry<FluidKey, Long>> iterator = MachineStorage.this.fluidMap.entrySet().iterator();
            if (iterator.hasNext()) {
                return this.drainInternal(iterator.next(), maxDrain, action);
            }
            return FluidStack.EMPTY;
        }

        private FluidStack drainInternal(Map.Entry<FluidKey, Long> entry, int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack drained = entry.getKey().toStack((int)Math.min(entry.getValue(), (long)maxDrain));
            if (action.execute()) {
                MachineStorage.this.putFluid(entry.getKey(), entry.getValue() - (long)drained.getAmount());
            }
            return drained;
        }
    }

    private class StorageItemHandler
    implements IItemHandler {
        private StorageItemHandler() {
        }

        public int getSlots() {
            return MachineStorage.this.itemMap.size();
        }

        private Optional<Map.Entry<ItemKey, Long>> getByIndex(int index) {
            if (0 <= index && index < this.getSlots()) {
                return Optional.of((Map.Entry)Iterators.get(MachineStorage.this.itemMap.entrySet().iterator(), (int)index));
            }
            return Optional.empty();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.getByIndex(slot).map(e -> ((ItemKey)e.getKey()).toStack((int)Math.min((Long)e.getValue(), Integer.MAX_VALUE))).orElse(ItemStack.EMPTY);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            Optional<Map.Entry<ItemKey, Long>> entry = this.getByIndex(slot);
            if (entry.isPresent()) {
                ItemKey key = entry.get().getKey();
                long storageCount = entry.get().getValue();
                int size = (int)Math.min((long)amount, storageCount);
                if (!simulate) {
                    if (storageCount > (long)amount) {
                        MachineStorage.this.itemMap.put(key, storageCount - (long)amount);
                    } else {
                        MachineStorage.this.itemMap.remove(key);
                    }
                }
                return key.toStack(size);
            }
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

