/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.Holder;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.jetbrains.annotations.Nullable;

public class QPBlock
extends Block {
    public static final BooleanProperty WORKING = BooleanProperty.create((String)"working");
    public final BlockItem blockItem;

    public QPBlock(BlockBehaviour.Properties properties, String name, Function<QPBlock, QPBlockItem> itemFunction) {
        super(properties);
        this.setRegistryName("quarryplus", name);
        this.blockItem = itemFunction.apply(this);
        this.blockItem.setRegistryName("quarryplus", name);
    }

    public QPBlock(BlockBehaviour.Properties properties, String name) {
        this(properties, name, b -> new QPBlockItem((QPBlock)((Object)b), new Item.Properties().tab(Holder.TAB)));
    }

    public final Item asItem() {
        return this.blockItem;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> type1, BlockEntityType<E> exceptedType, BlockEntityTicker<? super E> ticker) {
        return exceptedType == type1 ? ticker : null;
    }

    public static class QPBlockItem
    extends BlockItem {
        public QPBlockItem(QPBlock block, Item.Properties properties) {
            super((Block)block, properties);
        }

        public String toString() {
            return Objects.requireNonNull(this.getRegistryName()).getPath();
        }
    }
}

