/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.advpump.TileAdvPump;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public final class AdvPumpMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final boolean placeFrame;
    private final boolean deleteFluid;

    AdvPumpMessage(BlockPos pos, ResourceKey<Level> dim, boolean placeFrame, boolean deleteFluid) {
        this.pos = pos;
        this.dim = dim;
        this.placeFrame = placeFrame;
        this.deleteFluid = deleteFluid;
    }

    AdvPumpMessage(TileAdvPump advPump) {
        this(advPump.getBlockPos(), (ResourceKey<Level>)Objects.requireNonNull(advPump.getLevel()).dimension(), advPump.placeFrame, advPump.deleteFluid);
    }

    public AdvPumpMessage(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)buf.readResourceLocation()), buf.readBoolean(), buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos).writeResourceLocation(this.dim.location());
        buf.writeBoolean(this.placeFrame).writeBoolean(this.deleteFluid);
    }

    public static void onReceive(AdvPumpMessage message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> level = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> level.flatMap(l -> l.getBlockEntity(message.pos, Holder.ADV_PUMP_TYPE)).ifPresentOrElse(pump -> {
            pump.deleteFluid = message.deleteFluid;
            pump.placeFrame = message.placeFrame;
        }, () -> QuarryPlus.LOGGER.warn("{} can't find tile at {} in {}", (Object)message.getClass().getName(), (Object)message.pos, message.dim)));
    }
}

