/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.advpump.AdvPumpMenu;
import com.yogpc.qp.machines.advpump.AdvPumpMessage;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.packet.PacketHandler;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class AdvPumpScreen
extends AbstractContainerScreen<AdvPumpMenu>
implements Button.OnPress {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/adv_pump.png");

    public AdvPumpScreen(AdvPumpMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        this.renderTooltip(matrices, mouseX, mouseY);
    }

    protected void renderBg(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION);
        this.blit(matrices, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        super.renderLabels(pPoseStack, pMouseX, pMouseY);
    }

    protected void init() {
        super.init();
        int buttonWidth = 80;
        this.addRenderableWidget((GuiEventListener)new IndexedButton(0, this.getGuiLeft() + this.getXSize() / 2 - 80, this.getGuiTop() + 22, 80, 20, this.text("Frame", ((AdvPumpMenu)this.getMenu()).pump.placeFrame), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(1, this.getGuiLeft() + this.getXSize() / 2, this.getGuiTop() + 22, 80, 20, this.text("Delete", ((AdvPumpMenu)this.getMenu()).pump.deleteFluid), this));
    }

    private Component text(String prefix, boolean state) {
        return new TextComponent("%s %s".formatted(prefix, state ? "on" : "off"));
    }

    public void onPress(Button button) {
        if (button instanceof IndexedButton) {
            IndexedButton indexedButton = (IndexedButton)button;
            switch (indexedButton.getIndex()) {
                case 0: {
                    ((AdvPumpMenu)this.getMenu()).pump.placeFrame = !((AdvPumpMenu)this.getMenu()).pump.placeFrame;
                    indexedButton.setMessage(this.text("Frame", ((AdvPumpMenu)this.getMenu()).pump.placeFrame));
                    PacketHandler.sendToServer(new AdvPumpMessage(((AdvPumpMenu)this.getMenu()).pump));
                    break;
                }
                case 1: {
                    ((AdvPumpMenu)this.getMenu()).pump.deleteFluid = !((AdvPumpMenu)this.getMenu()).pump.deleteFluid;
                    indexedButton.setMessage(this.text("Delete", ((AdvPumpMenu)this.getMenu()).pump.deleteFluid));
                    PacketHandler.sendToServer(new AdvPumpMessage(((AdvPumpMenu)this.getMenu()).pump));
                    break;
                }
            }
        }
    }
}

