/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.wrench.WrenchItems;
import com.yogpc.qp.machines.EnchantedLootFunction;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.advpump.EnchantmentEfficiency;
import com.yogpc.qp.machines.advpump.ItemAdvPump;
import com.yogpc.qp.machines.advpump.TileAdvPump;
import com.yogpc.qp.machines.module.ContainerQuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class BlockAdvPump
extends QPBlock
implements EntityBlock {
    public static final String NAME = "adv_pump";

    public BlockAdvPump() {
        super(BlockBehaviour.Properties.of((Material)Material.METAL).strength(1.5f, 10.0f).sound(SoundType.STONE), NAME, ItemAdvPump::new);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WORKING, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Holder.ADV_PUMP_TYPE.create(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WORKING});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : BlockAdvPump.checkType(type, Holder.ADV_PUMP_TYPE, new CombinedBlockEntityTicker(PowerTile.getGenerator(), TileAdvPump::tick, PowerTile.logTicker(), MachineStorage.passFluid()));
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!world.isClientSide) {
                player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.getName()}), true);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        ItemStack stack = player.getItemInHand(hand);
        if (WrenchItems.isWrenchItem(stack)) {
            BlockEntity blockEntity;
            if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof TileAdvPump) {
                TileAdvPump pump = (TileAdvPump)blockEntity;
                pump.reset();
                pump.deleteFluid = !pump.deleteFluid;
                player.displayClientMessage((Component)new TextComponent("AdvPump DeleteFluid: " + pump.deleteFluid), false);
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            BlockEntity blockEntity;
            if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof TileAdvPump) {
                TileAdvPump pump = (TileAdvPump)blockEntity;
                if (stack.getItem() instanceof QuarryModuleProvider.Item) {
                    ContainerQuarryModule.InteractionObject.openGUI(pump, (ServerPlayer)player, (Component)this.getName());
                } else {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)pump, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TileAdvPump) {
            TileAdvPump pump = (TileAdvPump)blockEntity;
            boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos, pump.enabled);
            pump.setEnchantment(EnchantmentEfficiency.fromMap(EnchantmentHelper.getEnchantments((ItemStack)stack)));
            pump.setChunkPreLoaded(preForced);
            pump.updateModule();
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TileAdvPump) {
                TileAdvPump pump = (TileAdvPump)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)pump.getModuleInventory());
            }
            super.onRemove(state, level, pos, newState, moved);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TileAdvPump) {
            TileAdvPump pump = (TileAdvPump)blockEntity;
            EnchantedLootFunction.process(stack, pump);
        }
        return stack;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, world, pos, block, fromPos, notify);
        if (!world.isClientSide) {
            world.getBlockEntity(pos, Holder.ADV_PUMP_TYPE).ifPresent(TileAdvPump::updateModule);
        }
    }
}

