/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.FluidKey;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.advpump.AdvPumpMenu;
import com.yogpc.qp.machines.advpump.BlockAdvPump;
import com.yogpc.qp.machines.advpump.EnchantmentEfficiency;
import com.yogpc.qp.machines.advpump.Target;
import com.yogpc.qp.machines.module.EnergyModuleItem;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.machines.module.RepeatTickModuleItem;
import com.yogpc.qp.machines.module.ReplacerModule;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.CacheEntry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class TileAdvPump
extends PowerTile
implements MachineStorage.HasStorage,
EnchantmentLevel.HasEnchantments,
CheckerLog,
ClientSync,
ModuleInventory.HasModuleInventory,
MenuProvider {
    private final MachineStorage storage = new MachineStorage();
    private int y;
    private Target target;
    private EnchantmentEfficiency enchantmentEfficiency;
    private boolean finished = false;
    public boolean deleteFluid = false;
    public boolean placeFrame = true;
    private final ModuleInventory moduleInventory;
    private Set<QuarryModule> modules = Set.of();
    private boolean isBlockModuleLoaded = false;
    private final AdvPumpCache cache = new AdvPumpCache();

    public TileAdvPump(BlockPos pos, BlockState state) {
        super(Holder.ADV_PUMP_TYPE, pos, state);
        this.y = pos.getY() - 1;
        this.setEnchantment(new EnchantmentEfficiency(List.of()));
        this.moduleInventory = new ModuleInventory(5, this::updateModule, TileAdvPump::isCapableModule, (ModuleInventory.HasModuleInventory)this);
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        nbt.put("storage", (Tag)this.storage.toNbt());
        nbt.putInt("y", this.y);
        nbt.put("enchantments", (Tag)this.enchantmentEfficiency.toNbt());
        nbt.putBoolean("finished", this.finished);
        nbt.putBoolean("deleteFluid", this.deleteFluid);
        nbt.putBoolean("placeFrame", this.placeFrame);
        nbt.put("moduleInventory", (Tag)this.moduleInventory.serializeNBT());
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.storage.readNbt(nbt.getCompound("storage"));
        this.y = nbt.getInt("y");
        this.setEnchantment(EnchantmentEfficiency.fromNbt(nbt.getCompound("enchantments")));
        this.finished = nbt.getBoolean("finished");
        this.deleteFluid = nbt.getBoolean("deleteFluid");
        this.placeFrame = nbt.getBoolean("placeFrame");
        this.moduleInventory.deserializeNBT(nbt.getCompound("moduleInventory"));
        this.isBlockModuleLoaded = false;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TileAdvPump pump) {
        if (!pump.isBlockModuleLoaded) {
            pump.updateModule();
            pump.isBlockModuleLoaded = true;
        }
        for (int i = 0; i < pump.getRepeatWorkCount(); ++i) {
            TileAdvPump.drainOnce(world, pos, state, pump);
        }
    }

    private static void drainOnce(Level world, BlockPos pos, BlockState state, TileAdvPump pump) {
        long fluidSum = pump.storage.getFluidMap().values().stream().mapToLong(Long::longValue).sum();
        if (pump.hasEnoughEnergy() && !pump.finished && fluidSum <= (long)pump.enchantmentEfficiency.fluidCapacity) {
            if (pump.target == null) {
                BlockPos initPos = pos.atY(pump.y);
                pump.target = Target.getTarget(world, initPos, pump.enchantmentEfficiency.rangePredicate(initPos), pump::isReplaceBlock, pump.enchantmentEfficiency.areaSize());
                world.setBlock(pos, (BlockState)state.setValue((Property)BlockAdvPump.WORKING, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (pump.target.hasNext()) {
                while (pump.target.hasNext()) {
                    BlockPos target = pump.target.next();
                    BreakResult result = pump.pumpFluid(world, target, pump::getStateForReplace, true);
                    if (result.isSuccess()) {
                        if (!pump.placeFrame) continue;
                        Direction.Plane.HORIZONTAL.stream().map(arg_0 -> ((BlockPos)target).relative(arg_0)).filter(pump.target.getPredicate().negate()).forEach(p -> pump.pumpFluid(world, (BlockPos)p, f -> Holder.BLOCK_FRAME.getDammingState(), false));
                        continue;
                    }
                    break;
                }
            } else if (!pump.target.checkAllFluidsRemoved(world, pos.atY(pump.y))) {
                --pump.y;
                BlockPos nextPos = pos.atY(pump.y);
                if (pump.shouldFinish(world, nextPos)) {
                    pump.finished = true;
                    pump.target = null;
                    world.setBlock(pos, (BlockState)state.setValue((Property)BlockAdvPump.WORKING, (Comparable)Boolean.valueOf(false)), 3);
                    pump.logUsage();
                    TileAdvPump.removeDummyBlock(world, pos, pump.y);
                } else {
                    pump.target = Target.getTarget(world, nextPos, pump.enchantmentEfficiency.rangePredicate(nextPos), pump::isReplaceBlock, pump.enchantmentEfficiency.areaSize());
                }
            }
        }
    }

    private static void removeDummyBlock(Level level, BlockPos pos, int minY) {
        for (int i = pos.getY() - 1; i > minY; --i) {
            BlockPos withY = pos.atY(i);
            BlockState blockState = level.getBlockState(withY);
            if (blockState.is((Block)Holder.BLOCK_DUMMY)) {
                level.removeBlock(withY, false);
                break;
            }
            if (!blockState.isAir()) break;
        }
    }

    private boolean shouldFinish(Level world, BlockPos nextPos) {
        BlockState blockState = world.getBlockState(nextPos);
        boolean blockCondition = blockState.isAir() || blockState.is((Block)Holder.BLOCK_DUMMY) || this.isReplaceBlock(blockState);
        return world.getFluidState(nextPos).isEmpty() && !blockCondition;
    }

    private BreakResult pumpFluid(Level world, BlockPos target, Function<FluidState, BlockState> replaceBlockGetter, boolean useEnergy) {
        Block block;
        FluidState fluidState = world.getFluidState(target);
        if (fluidState.isEmpty()) {
            return BreakResult.SKIPPED;
        }
        if (!fluidState.isSource()) {
            world.setBlock(target, replaceBlockGetter.apply(fluidState), 3);
            return BreakResult.SUCCESS;
        }
        if (useEnergy && !this.useEnergy(this.enchantmentEfficiency.baseEnergy, PowerTile.Reason.ADV_PUMP_FLUID, false)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        BlockState blockState = world.getBlockState(target);
        if (!(blockState.getBlock() instanceof LiquidBlock) && (block = blockState.getBlock()) instanceof BucketPickup) {
            BucketPickup drain = (BucketPickup)block;
            ItemStack drained = drain.pickupBlock((LevelAccessor)world, target, blockState);
            if (!this.deleteFluid) {
                this.storage.addFluid(drained);
            }
        } else {
            if (!this.deleteFluid) {
                this.storage.addFluid(fluidState.getType(), 1000L);
            }
            world.setBlock(target, replaceBlockGetter.apply(fluidState), 3);
        }
        return BreakResult.SUCCESS;
    }

    void setEnchantment(EnchantmentEfficiency enchantmentEfficiency) {
        this.enchantmentEfficiency = enchantmentEfficiency;
        this.setMaxEnergy(enchantmentEfficiency.energyCapacity);
        if (this.level != null && !this.level.isClientSide) {
            this.sync();
        }
    }

    @NotNull
    private Optional<BlockState> getReplaceModuleState() {
        return this.cache.replaceModuleState.getValue(this.getLevel());
    }

    private BlockState getStateForReplace(FluidState f) {
        return this.getReplaceModuleState().orElse(f.is(FluidTags.WATER) ? Holder.BLOCK_DUMMY.defaultBlockState() : Blocks.AIR.defaultBlockState());
    }

    private boolean isReplaceBlock(BlockState state) {
        return state == this.getReplaceModuleState().orElse(Holder.BLOCK_DUMMY.defaultBlockState());
    }

    public void reset() {
        this.target = null;
        this.finished = false;
        this.y = this.getBlockPos().getY() - 1;
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return this.enchantmentEfficiency.getEnchantments();
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        List<TextComponent> fluidSummery = this.storage.getFluidMap().entrySet().stream().map(e -> "%s: %d mB".formatted(((FluidKey)e.getKey()).getId(), e.getValue())).map(TextComponent::new).toList();
        List<TextComponent> fluidMessage = fluidSummery.isEmpty() ? List.of(new TextComponent("No Fluid.")) : fluidSummery;
        return Stream.concat(fluidMessage.stream(), Stream.of("%sModules:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.modules), "%sRemove:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.deleteFluid), "%sFrame:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.placeFrame), this.energyString()).map(TextComponent::new)).toList();
    }

    @Override
    public void fromClientTag(CompoundTag tag) {
        this.load(tag);
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag) {
        return this.saveWithoutMetadata();
    }

    public void sync() {
        if (this.level != null && !this.level.isClientSide) {
            PacketHandler.sendToClient(new ClientSyncMessage(this), this.level);
        }
    }

    void updateModule() {
        Set blockModules = this.level != null ? QuarryModuleProvider.Block.getModulesInWorld(this.level, this.getBlockPos()) : Collections.emptySet();
        List<QuarryModule> itemModules = this.moduleInventory.getModules();
        this.modules = Stream.concat(blockModules.stream(), itemModules.stream()).collect(Collectors.toSet());
        if (this.getReplacerModule().isPresent()) {
            this.placeFrame = false;
        }
    }

    static boolean isCapableModule(QuarryModule module) {
        return module instanceof EnergyModuleItem.EnergyModule || module instanceof ReplacerModule || module == QuarryModule.Constant.FILLER || module instanceof RepeatTickModuleItem.RepeatTickModule;
    }

    @Override
    public ModuleInventory getModuleInventory() {
        return this.moduleInventory;
    }

    @Override
    public Set<QuarryModule> getLoadedModules() {
        return this.modules;
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new AdvPumpMenu(i, player, this.getBlockPos());
    }

    private class AdvPumpCache {
        final CacheEntry<Optional<BlockState>> replaceModuleState = CacheEntry.supplierCache(5L, () -> TileAdvPump.this.getReplacerModule().map(ReplacerModule::getState).filter(Predicate.not(BlockBehaviour.BlockStateBase::isAir)).filter(b -> !b.is((Block)Holder.BLOCK_DUMMY_REPLACER)).or(() -> TileAdvPump.this.hasFillerModule() ? Optional.of(Blocks.STONE.defaultBlockState()) : Optional.empty()));
    }
}

