/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.advquarry.AdvQuarry;
import com.yogpc.qp.machines.advquarry.AdvQuarryAction;
import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.MapMulti;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public final class AdvActionMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final Area area;
    private final Actions action;

    AdvActionMessage(TileAdvQuarry quarry, Actions action, Area area) {
        this.pos = quarry.getBlockPos();
        this.dim = PacketHandler.getDimension(quarry);
        this.area = area;
        this.action = action;
        AdvQuarry.LOGGER.debug(AdvQuarry.MESSAGE, "Message is created. {} {} {} {}", (Object)this.pos, (Object)this.dim.location(), (Object)this.area, (Object)this.action);
    }

    AdvActionMessage(TileAdvQuarry quarry, Actions action) {
        this(quarry, action, quarry.getArea());
    }

    public AdvActionMessage(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.dim = ResourceKey.create((ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)buf.readResourceLocation());
        this.area = Area.fromNBT(buf.readNbt()).orElse(null);
        this.action = (Actions)buf.readEnum(Actions.class);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos).writeResourceLocation(this.dim.location());
        buf.writeNbt(this.area.toNBT());
        buf.writeEnum((Enum)this.action);
    }

    public static void onReceive(AdvActionMessage message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> world = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> world.map(w -> w.getBlockEntity(message.pos)).flatMap(MapMulti.optCast(TileAdvQuarry.class)).ifPresent(arg_0 -> AdvActionMessage.lambda$onReceive$3(message, (Supplier)supplier, arg_0)));
    }

    private static /* synthetic */ void lambda$onReceive$3(AdvActionMessage message, Supplier supplier, TileAdvQuarry quarry) {
        AdvQuarry.LOGGER.debug(AdvQuarry.MESSAGE, "onReceive. {}, {}", (Object)message.pos, (Object)message.action);
        switch (message.action) {
            case CHANGE_RANGE: {
                quarry.setArea(message.area, arg_0 -> AdvActionMessage.lambda$onReceive$2((Supplier)supplier, arg_0));
                break;
            }
            case MODULE_INV: {
                PacketHandler.getPlayer((NetworkEvent.Context)supplier.get()).flatMap(MapMulti.optCast(ServerPlayer.class)).ifPresent(quarry::openModuleGui);
                break;
            }
            case QUICK_START: {
                if (!quarry.canStartWork()) break;
                quarry.setAction(new AdvQuarryAction.BreakBlock(quarry));
            }
        }
    }

    private static /* synthetic */ void lambda$onReceive$2(Supplier supplier, Component c) {
        PacketHandler.getPlayer((NetworkEvent.Context)supplier.get()).ifPresent(p -> p.displayClientMessage(c, false));
    }

    static enum Actions {
        QUICK_START,
        MODULE_INV,
        CHANGE_RANGE;

    }
}

