/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.advquarry.AdvActionMessage;
import com.yogpc.qp.machines.advquarry.AdvQuarryAction;
import com.yogpc.qp.machines.advquarry.AdvQuarryMenu;
import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.packet.PacketHandler;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;

public class AdvQuarryScreen
extends AbstractContainerScreen<AdvQuarryMenu>
implements Button.OnPress {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/adv_quarry.png");

    public AdvQuarryScreen(AdvQuarryMenu c, Inventory inventory, Component component) {
        super((AbstractContainerMenu)c, inventory, component);
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        this.renderTooltip(matrices, mouseX, mouseY);
    }

    protected void renderBg(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION);
        this.blit(matrices, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(PoseStack matrices, int mouseX, int mouseY) {
        super.renderLabels(matrices, mouseX, mouseY);
        Area range = ((AdvQuarryMenu)this.getMenu()).quarry.getArea();
        if (range != null) {
            ChunkPos chunkPos = new ChunkPos(((AdvQuarryMenu)this.getMenu()).quarry.getBlockPos());
            double north = chunkPos.getMinBlockZ() - range.minZ() - 1;
            double south = range.maxZ() - chunkPos.getMaxBlockZ() - 1;
            double east = range.maxX() - chunkPos.getMaxBlockX() - 1;
            double west = chunkPos.getMinBlockX() - range.minX() - 1;
            this.font.draw(matrices, String.valueOf(north / 16.0), 79.0f, 17.0f, 0x404040);
            this.font.draw(matrices, String.valueOf(south / 16.0), 79.0f, 63.0f, 0x404040);
            this.font.draw(matrices, String.valueOf(west / 16.0), 19.0f, 40.0f, 0x404040);
            this.font.draw(matrices, String.valueOf(east / 16.0), 139.0f, 40.0f, 0x404040);
        }
    }

    protected void init() {
        super.init();
        TextComponent plus = new TextComponent("+");
        TextComponent minus = new TextComponent("-");
        this.addRenderableWidget((GuiEventListener)new IndexedButton(0, this.getGuiLeft() + 98, this.getGuiTop() + 16, 10, 8, (Component)plus, this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(1, this.getGuiLeft() + 68, this.getGuiTop() + 16, 10, 8, (Component)minus, this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(2, this.getGuiLeft() + 98, this.getGuiTop() + 62, 10, 8, (Component)plus, this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(3, this.getGuiLeft() + 68, this.getGuiTop() + 62, 10, 8, (Component)minus, this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(4, this.getGuiLeft() + 38, this.getGuiTop() + 39, 10, 8, (Component)plus, this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(5, this.getGuiLeft() + 8, this.getGuiTop() + 39, 10, 8, (Component)minus, this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(6, this.getGuiLeft() + 158, this.getGuiTop() + 39, 10, 8, (Component)plus, this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(7, this.getGuiLeft() + 128, this.getGuiTop() + 39, 10, 8, (Component)minus, this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(8, this.getGuiLeft() + 108, this.getGuiTop() + 58, 60, 12, (Component)new TextComponent("No Frame"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(9, this.getGuiLeft() + 8, this.getGuiTop() + 58, 60, 12, (Component)new TextComponent("Modules"), this));
    }

    public void onPress(Button b) {
        if (b instanceof IndexedButton) {
            IndexedButton button = (IndexedButton)b;
            TileAdvQuarry tile = ((AdvQuarryMenu)this.getMenu()).quarry;
            if (button.id() == 8) {
                if (tile.getAction() == AdvQuarryAction.Waiting.WAITING) {
                    PacketHandler.sendToServer(new AdvActionMessage(tile, AdvActionMessage.Actions.QUICK_START));
                }
            } else if (button.id() == 9) {
                PacketHandler.sendToServer(new AdvActionMessage(tile, AdvActionMessage.Actions.MODULE_INV));
            } else if (tile.getAction() == AdvQuarryAction.Waiting.WAITING) {
                Direction direction = Direction.from3DDataValue((int)(button.id() / 2 + 2));
                int increase = button.id() % 2 == 0 ? 1 : -1;
                boolean shift = Screen.hasShiftDown();
                boolean ctrl = Screen.hasControlDown();
                int t = shift && ctrl ? 1024 * increase : (shift ? 256 * increase : (ctrl ? 64 * increase : 16 * increase));
                Area range = tile.getArea();
                if (range != null) {
                    Area newRange = switch (direction.getAxis()) {
                        case Direction.Axis.X -> {
                            int e;
                            switch (direction.getAxisDirection()) {
                                case POSITIVE: {
                                    e = range.maxX();
                                    if (range.minX() < e + t) {
                                        yield new Area(range.minX(), range.minY(), range.minZ(), e + t, range.maxY(), range.maxZ(), range.direction());
                                    }
                                    yield range;
                                }
                                case NEGATIVE: {
                                    e = range.minX();
                                    if (range.maxX() > e - t) {
                                        yield new Area(e - t, range.minY(), range.minZ(), range.maxX(), range.maxY(), range.maxZ(), range.direction());
                                    }
                                    yield range;
                                }
                            }
                            yield range;
                        }
                        case Direction.Axis.Z -> {
                            int e;
                            switch (direction.getAxisDirection()) {
                                case POSITIVE: {
                                    e = range.maxZ();
                                    if (range.minZ() < e + t) {
                                        yield new Area(range.minX(), range.minY(), range.minZ(), range.maxX(), range.maxY(), e + t, range.direction());
                                    }
                                    yield range;
                                }
                                case NEGATIVE: {
                                    e = range.minZ();
                                    if (range.maxZ() > e - t) {
                                        yield new Area(range.minX(), range.minY(), e - t, range.maxX(), range.maxY(), range.maxZ(), range.direction());
                                    }
                                    yield range;
                                }
                            }
                            yield range;
                        }
                        default -> tile.getArea();
                    };
                    PacketHandler.sendToServer(new AdvActionMessage(tile, AdvActionMessage.Actions.CHANGE_RANGE, newRange));
                }
            }
        }
    }
}

