/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.wrench.WrenchItems;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.EnchantedLootFunction;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.machines.advquarry.AdvQuarry;
import com.yogpc.qp.machines.advquarry.AdvQuarryAction;
import com.yogpc.qp.machines.advquarry.ItemAdvQuarry;
import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import com.yogpc.qp.machines.module.EnergyModuleItem;
import com.yogpc.qp.machines.module.ModuleLootFunction;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.MapMulti;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class BlockAdvQuarry
extends QPBlock
implements EntityBlock {
    public static final String NAME = "adv_quarry";

    public BlockAdvQuarry() {
        super(BlockBehaviour.Properties.of((Material)Material.METAL).strength(1.5f, 10.0f).sound(SoundType.STONE), NAME, ItemAdvQuarry::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WORKING, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Holder.ADV_QUARRY_TYPE.create(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WORKING, BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getPlayer() == null ? Direction.NORTH : ctx.getPlayer().getDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, world, pos, block, fromPos, notify);
        if (!world.isClientSide) {
            world.getBlockEntity(pos, Holder.ADV_QUARRY_TYPE).ifPresent(TileAdvQuarry::updateModule);
        }
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!level.isClientSide) {
                player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.getName()}), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        ItemStack stack = player.getItemInHand(hand);
        if (WrenchItems.isWrenchItem(stack)) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TileAdvQuarry) {
                TileAdvQuarry quarry = (TileAdvQuarry)blockEntity;
                quarry.setAction(AdvQuarryAction.Waiting.WAITING);
                player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.quarry.restart"), false);
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TileAdvQuarry) {
                TileAdvQuarry quarry = (TileAdvQuarry)blockEntity;
                if (stack.getItem() instanceof QuarryModuleProvider.Item) {
                    quarry.openModuleGui((ServerPlayer)player);
                } else {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)quarry, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TileAdvQuarry) {
            Area defaultArea;
            TileAdvQuarry quarry = (TileAdvQuarry)blockEntity;
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            List<EnchantmentLevel> enchantment = EnchantmentLevel.fromItem(stack);
            enchantment.sort(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR);
            quarry.initialSetting(enchantment);
            Consumer<Component> showErrorMessage = c -> {
                if (entity != null) {
                    entity.sendMessage(c, Util.NIL_UUID);
                }
            };
            if (!quarry.setArea(BlockAdvQuarry.findArea(level, pos, facing.getOpposite(), quarry.getStorage()::addItem), showErrorMessage) && !quarry.setArea(defaultArea = BlockAdvQuarry.createDefaultArea(pos, facing.getOpposite(), (Integer)QuarryPlus.config.common.chunkDestroyerLimit.get()), showErrorMessage)) {
                AdvQuarry.LOGGER.warn(AdvQuarry.BLOCK, "The default area is invalid. Area={}, Limit={}, Pos={}", (Object)defaultArea, QuarryPlus.config.common.chunkDestroyerLimit.get(), (Object)pos);
            }
            boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos, quarry.enabled);
            quarry.setChunkPreLoaded(preForced);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BlockAdvQuarry.checkType(type, Holder.ADV_QUARRY_TYPE, new CombinedBlockEntityTicker(PowerTile.getGenerator(), EnergyModuleItem.energyModuleTicker(), TileAdvQuarry::tick, PowerTile.logTicker(), MachineStorage.passItems(), MachineStorage.passFluid()));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TileAdvQuarry) {
            TileAdvQuarry quarry = (TileAdvQuarry)blockEntity;
            EnchantedLootFunction.process(stack, quarry);
            ModuleLootFunction.process(stack, quarry);
        }
        return stack;
    }

    static Area findArea(Level world, BlockPos pos, Direction quarryBehind, Consumer<ItemStack> itemCollector) {
        return Stream.of(quarryBehind, quarryBehind.getCounterClockWise(), quarryBehind.getClockWise()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).map(arg_0 -> ((Level)world).getBlockEntity(arg_0)).mapMulti(MapMulti.cast(QuarryMarker.class)).flatMap(m -> m.getArea().stream().peek(a -> m.removeAndGetItems().forEach(itemCollector))).map(a -> a.assureY(4)).findFirst().orElseGet(() -> BlockAdvQuarry.createDefaultArea(pos, quarryBehind, (Integer)QuarryPlus.config.common.chunkDestroyerLimit.get()));
    }

    @NotNull
    @VisibleForTesting
    static Area createDefaultArea(BlockPos pos, Direction quarryBehind, int limit) {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        ChunkPos chunkPos = new ChunkPos(pos);
        if (0 < limit && limit < 16) {
            if (pos.getX() - limit / 2 < chunkPos.getMinBlockX()) {
                minX = chunkPos.getMinBlockX();
                maxX = minX + limit - 1;
            } else if (pos.getX() + limit / 2 > chunkPos.getMaxBlockX()) {
                maxX = chunkPos.getMaxBlockX();
                minX = maxX - limit + 1;
            } else {
                minX = pos.getX() - limit / 2;
                maxX = minX + limit - 1;
            }
            if (pos.getZ() - limit / 2 < chunkPos.getMinBlockZ()) {
                minZ = chunkPos.getMinBlockZ();
                maxZ = minZ + limit - 1;
            } else if (pos.getZ() + limit / 2 > chunkPos.getMaxBlockZ()) {
                maxZ = chunkPos.getMaxBlockZ();
                minZ = maxZ - limit + 1;
            } else {
                minZ = pos.getZ() - limit / 2;
                maxZ = minZ + limit - 1;
            }
        } else {
            minX = chunkPos.getMinBlockX();
            maxX = chunkPos.getMaxBlockX();
            minZ = chunkPos.getMinBlockZ();
            maxZ = chunkPos.getMaxBlockZ();
        }
        return new Area(minX - 1, pos.getY(), minZ - 1, maxX + 1, pos.getY() + 4, maxZ + 1, quarryBehind);
    }
}

