/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.EnchantableItem;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModule;
import java.util.List;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

class ItemAdvQuarry
extends QPBlock.QPBlockItem
implements EnchantableItem {
    ItemAdvQuarry(QPBlock block) {
        super(block, new Item.Properties().tab(Holder.TAB).fireResistant());
    }

    public void fillItemCategory(CreativeModeTab tab, NonNullList<ItemStack> stacks) {
        super.fillItemCategory(tab, stacks);
        if (this.allowdedIn(tab)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            ItemStack copy = stack.copy();
            copy.enchant(Enchantments.BLOCK_EFFICIENCY, 5);
            copy.enchant(Enchantments.UNBREAKING, 3);
            copy.enchant(Enchantments.BLOCK_FORTUNE, 3);
            stacks.add((Object)copy);
            copy = stack.copy();
            copy.enchant(Enchantments.BLOCK_EFFICIENCY, 5);
            copy.enchant(Enchantments.UNBREAKING, 3);
            copy.enchant(Enchantments.SILK_TOUCH, 1);
            stacks.add((Object)copy);
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, level, list, flag);
        CompoundTag entityTag = BlockItem.getBlockEntityData((ItemStack)stack);
        if (entityTag != null) {
            List<QuarryModule> modules = ModuleInventory.loadModulesFromTag(entityTag.getCompound("moduleInventory"));
            modules.stream().map(Object::toString).map(TextComponent::new).forEach(list::add);
        }
    }

    @Override
    public Set<Enchantment> acceptEnchantments() {
        return QuarryPlus.config.acceptableEnchantmentsMap.getAllowedEnchantments(this.getRegistryName());
    }
}

