/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.ftbchunks.FTBChunksProtectionCheck;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentHolder;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.ItemConverter;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerConfig;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.advquarry.AdvQuarry;
import com.yogpc.qp.machines.advquarry.AdvQuarryAction;
import com.yogpc.qp.machines.advquarry.AdvQuarryMenu;
import com.yogpc.qp.machines.advquarry.BlockAdvQuarry;
import com.yogpc.qp.machines.module.ContainerQuarryModule;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.machines.module.ReplacerModule;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.CacheEntry;
import com.yogpc.qp.utils.MapMulti;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class TileAdvQuarry
extends PowerTile
implements CheckerLog,
ModuleInventory.HasModuleInventory,
MachineStorage.HasStorage,
EnchantmentLevel.HasEnchantments,
ClientSync,
MenuProvider,
PowerConfig.Provider {
    private final ModuleInventory moduleInventory = new ModuleInventory(5, this::updateModule, TileAdvQuarry::moduleFilter, (ModuleInventory.HasModuleInventory)this);
    private Set<QuarryModule> modules = Set.of();
    private boolean isBlockModuleLoaded = false;
    private final MachineStorage storage = new MachineStorage();
    private final QuarryCache cache = new QuarryCache();
    private final ItemConverter itemConverter = ItemConverter.defaultConverter().combined(ItemConverter.advQuarryConverter());
    public int digMinY;
    @Nullable
    private Area area = null;
    private List<EnchantmentLevel> enchantments = List.of();
    private AdvQuarryAction action = AdvQuarryAction.Waiting.WAITING;

    public TileAdvQuarry(BlockPos pos, BlockState state) {
        super(Holder.ADV_QUARRY_TYPE, pos, state);
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("%sArea:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.area), "%sAction:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.action), "%sRemoveBedrock:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.hasBedrockModule()), "%sDigMinY:%s %d".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.digMinY), "%sModules:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.modules), "%sCurrentWorkProgress:%s %.2f".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.xzProgress()), this.energyString()).map(TextComponent::new).toList();
    }

    private double xzProgress() {
        return this.action.getProgress(this);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TileAdvQuarry quarry) {
        if (!quarry.isBlockModuleLoaded) {
            quarry.updateModule();
            quarry.isBlockModuleLoaded = true;
        }
        if (quarry.hasEnoughEnergy()) {
            for (int i = 0; i < quarry.getRepeatWorkCount(); ++i) {
                quarry.action.tick(world, pos, state, quarry);
            }
        }
    }

    public AABB getRenderBoundingBox() {
        if (this.area != null) {
            int bottom = this.level == null ? 0 : this.level.getMinBuildHeight();
            return new AABB((double)this.area.minX(), (double)bottom, (double)this.area.minZ(), (double)this.area.maxX(), (double)this.area.maxY(), (double)this.area.maxZ());
        }
        return new AABB(this.getBlockPos(), this.getBlockPos().offset(1, 1, 1));
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        nbt.put("moduleInventory", (Tag)this.moduleInventory.serializeNBT());
        nbt.put("storage", (Tag)this.storage.toNbt());
        this.toClientTag(nbt);
    }

    public CompoundTag getUpdateTag() {
        return this.serializeNBT();
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.moduleInventory.deserializeNBT(nbt.getCompound("moduleInventory"));
        this.storage.readNbt(nbt.getCompound("storage"));
        this.fromClientTag(nbt);
        this.isBlockModuleLoaded = false;
    }

    @Override
    public CompoundTag toClientTag(CompoundTag nbt) {
        if (this.area != null) {
            nbt.put("area", (Tag)this.area.toNBT());
        }
        CompoundTag enchantments = new CompoundTag();
        this.enchantments.forEach(e -> enchantments.putInt(Objects.requireNonNull(e.enchantmentID()).toString(), e.level()));
        nbt.put("enchantments", (Tag)enchantments);
        nbt.putInt("digMinY", this.digMinY);
        nbt.put("action", (Tag)this.action.toNbt());
        return nbt;
    }

    @Override
    public void fromClientTag(CompoundTag nbt) {
        this.area = Area.fromNBT(nbt.getCompound("area")).orElse(null);
        CompoundTag enchantments = nbt.getCompound("enchantments");
        this.setEnchantments(enchantments.getAllKeys().stream().mapMulti(MapMulti.getEntry(ForgeRegistries.ENCHANTMENTS, arg_0 -> ((CompoundTag)enchantments).getInt(arg_0))).map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList());
        this.digMinY = nbt.getInt("digMinY");
        this.action = AdvQuarryAction.fromNbt(nbt.getCompound("action"), this);
    }

    public void setEnchantments(List<EnchantmentLevel> enchantments) {
        this.enchantments = enchantments;
        this.cache.enchantments.expire();
        this.setMaxEnergy(this.getPowerConfig().maxEnergy() * (long)(this.efficiencyLevel() + 1));
    }

    void initialSetting(List<EnchantmentLevel> enchantments) {
        this.setEnchantments(enchantments);
        if (this.level != null) {
            this.digMinY = this.level.getMinBuildHeight();
        }
    }

    @Nullable
    public Area getArea() {
        return this.area;
    }

    boolean setArea(Area newArea, Consumer<Component> showErrorMessage) {
        if (!newArea.isRangeInLimit((Integer)QuarryPlus.config.common.chunkDestroyerLimit.get(), true)) {
            showErrorMessage.accept((Component)new TranslatableComponent("quarryplus.chat.warn_cd_limit"));
            AdvQuarry.LOGGER.info(AdvQuarry.TILE, "Area is too bigger than limit value in config. Area={}, Limit={}", (Object)newArea, QuarryPlus.config.common.chunkDestroyerLimit.get());
            return false;
        }
        this.area = newArea;
        PacketHandler.sendToClient(new ClientSyncMessage(this), Objects.requireNonNull(this.getLevel()));
        if (FTBChunksProtectionCheck.isAreaProtected(newArea.shrink(1, 0, 1), (ResourceKey<Level>)this.getTargetWorld().dimension())) {
            showErrorMessage.accept((Component)new TranslatableComponent("quarryplus.chat.warn_protected_area"));
            AdvQuarry.LOGGER.info(AdvQuarry.TILE, "Area contains protected chunks. Quarry has stopped.");
        }
        return true;
    }

    public AdvQuarryAction getAction() {
        return this.action;
    }

    void setAction(AdvQuarryAction action) {
        AdvQuarryAction pre = this.action;
        if (this.action == AdvQuarryAction.Waiting.WAITING && this.level != null) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockAdvQuarry.WORKING, (Comparable)Boolean.valueOf(true)), 3);
        }
        this.action = action;
        if (action == AdvQuarryAction.Finished.FINISHED && this.level != null) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockAdvQuarry.WORKING, (Comparable)Boolean.valueOf(false)), 3);
            this.logUsage();
        }
        if (this.level != null && !this.level.isClientSide) {
            PacketHandler.sendToClient(new ClientSyncMessage(this), this.level);
            QuarryPlus.LOGGER.debug("ChunkDestroyer({}) State changed from {} to {}.", (Object)this.getBlockPos(), (Object)pre, (Object)action);
        }
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return this.enchantments;
    }

    public boolean canStartWork() {
        return this.area != null && !FTBChunksProtectionCheck.isAreaProtected(this.area.shrink(1, 0, 1), (ResourceKey<Level>)this.getTargetWorld().dimension());
    }

    public boolean canBreak(Level targetWorld, BlockPos targetPos, BlockState state) {
        boolean unbreakable;
        if (state.isAir()) {
            return true;
        }
        boolean bl = unbreakable = state.getDestroySpeed((BlockGetter)targetWorld, targetPos) < 0.0f;
        if (unbreakable) {
            if (this.hasBedrockModule() && state.getBlock() == Blocks.BEDROCK) {
                return !targetWorld.dimension().equals((Object)Level.END);
            }
            return false;
        }
        if (!targetWorld.getFluidState(targetPos).isEmpty()) {
            return true;
        }
        return this.getReplacementState() != state;
    }

    BlockState getReplacementState() {
        return this.cache.replaceState.getValue(this.level);
    }

    @Override
    public ModuleInventory getModuleInventory() {
        return this.moduleInventory;
    }

    void updateModule() {
        Set blockModules = this.level != null ? QuarryModuleProvider.Block.getModulesInWorld(this.level, this.getBlockPos()) : Collections.emptySet();
        List<QuarryModule> itemModules = this.moduleInventory.getModules();
        this.modules = Stream.concat(blockModules.stream(), itemModules.stream()).collect(Collectors.toSet());
    }

    static boolean moduleFilter(QuarryModule module) {
        return module != QuarryModule.Constant.PUMP;
    }

    @Override
    public Set<QuarryModule> getLoadedModules() {
        return this.modules;
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    public AdvQuarryMenu createMenu(int id, Inventory p, Player player) {
        return new AdvQuarryMenu(id, player, this.getBlockPos());
    }

    public ServerLevel getTargetWorld() {
        return (ServerLevel)this.level;
    }

    public BreakResult breakOneBlock(BlockPos targetPos, boolean requireEnergy) {
        ServerLevel targetWorld = this.getTargetWorld();
        ItemStack pickaxe = this.getPickaxe();
        FakePlayer fakePlayer = QuarryFakePlayer.get(targetWorld);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, pickaxe);
        BlockState state = targetWorld.getBlockState(targetPos);
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((Level)targetWorld, targetPos, state, (Player)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return BreakResult.FAIL_EVENT;
        }
        if (state.isAir() || !this.canBreak((Level)targetWorld, targetPos, state)) {
            return BreakResult.SKIPPED;
        }
        float hardness = state.getDestroySpeed((BlockGetter)targetWorld, targetPos);
        if (requireEnergy && !this.useEnergy(PowerManager.getBreakEnergy(hardness, this), PowerTile.Reason.BREAK_BLOCK, false)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        List drops = Block.getDrops((BlockState)state, (ServerLevel)targetWorld, (BlockPos)targetPos, (BlockEntity)targetWorld.getBlockEntity(targetPos), (Entity)fakePlayer, (ItemStack)pickaxe);
        drops.stream().map(this.itemConverter::map).forEach(this.storage::addItem);
        targetWorld.setBlock(targetPos, this.getReplacementState(), 3);
        if (breakEvent.getExpToDrop() > 0) {
            this.getExpModule().ifPresent(e -> {
                if (requireEnergy) {
                    this.useEnergy(PowerManager.getExpCollectEnergy(breakEvent.getExpToDrop(), this), PowerTile.Reason.EXP_COLLECT, true);
                }
                e.addExp(breakEvent.getExpToDrop());
            });
        }
        this.setChanged();
        return BreakResult.SUCCESS;
    }

    BreakResult breakBlocks(int x, int z) {
        ServerLevel targetWorld = this.getTargetWorld();
        ItemStack pickaxe = this.getPickaxe();
        FakePlayer fakePlayer = QuarryFakePlayer.get(targetWorld);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, pickaxe);
        AABB aabb = new AABB((double)(x - 5), (double)(this.digMinY - 5), (double)(z - 5), (double)(x + 5), (double)(this.getBlockPos().getY() - 1), (double)(z + 5));
        targetWorld.getEntitiesOfClass(ItemEntity.class, aabb, Predicate.not(i -> i.getItem().isEmpty())).forEach(i -> {
            this.storage.addItem(i.getItem());
            i.kill();
        });
        this.getExpModule().ifPresent(e -> targetWorld.getEntitiesOfClass(ExperienceOrb.class, aabb, EntitySelector.ENTITY_STILL_ALIVE).forEach(orb -> {
            e.addExp(orb.getValue());
            orb.kill();
        }));
        this.removeEdgeFluid(x, z, targetWorld);
        long requiredEnergy = 0L;
        AtomicInteger exp = new AtomicInteger(0);
        ArrayList<Pair> toBreak = new ArrayList<Pair>();
        ArrayList<Pair> toDrain = new ArrayList<Pair>();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, 0, z);
        for (int y = this.getBlockPos().getY() - 1; y > this.digMinY; --y) {
            mutableBlockPos.setY(y);
            BlockState state = targetWorld.getBlockState((BlockPos)mutableBlockPos);
            FluidState fluidState = targetWorld.getFluidState((BlockPos)mutableBlockPos);
            if (fluidState.isEmpty()) {
                if (state.isAir()) continue;
                if (!this.canBreak((Level)targetWorld, (BlockPos)mutableBlockPos, state)) {
                    if (state.getBlock() != Blocks.NETHER_PORTAL) continue;
                    targetWorld.removeBlock((BlockPos)mutableBlockPos, false);
                    continue;
                }
                BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((Level)targetWorld, (BlockPos)mutableBlockPos, state, (Player)fakePlayer);
                MinecraftForge.EVENT_BUS.post((Event)breakEvent);
                if (breakEvent.isCanceled()) continue;
                exp.getAndAdd(breakEvent.getExpToDrop());
                float hardness = state.getDestroySpeed((BlockGetter)targetWorld, (BlockPos)mutableBlockPos);
                long energy = PowerManager.getBreakEnergy(hardness, this);
                requiredEnergy += energy;
                toBreak.add(Pair.of((Object)mutableBlockPos.immutable(), (Object)state));
                continue;
            }
            long energy = PowerManager.getBreakBlockFluidEnergy(this);
            requiredEnergy += energy;
            toDrain.add(Pair.of((Object)mutableBlockPos.immutable(), (Object)state));
        }
        if (toBreak.isEmpty() && toDrain.isEmpty()) {
            return BreakResult.SKIPPED;
        }
        this.useEnergy(requiredEnergy, PowerTile.Reason.BREAK_BLOCK, true);
        for (Pair pair : toDrain) {
            BlockState state;
            Block energy = ((BlockState)pair.getRight()).getBlock();
            if (energy instanceof BucketPickup) {
                BucketPickup fluidBlock = (BucketPickup)energy;
                ItemStack bucketItem = fluidBlock.pickupBlock((LevelAccessor)targetWorld, (BlockPos)pair.getLeft(), (BlockState)pair.getRight());
                this.storage.addFluid(bucketItem);
            }
            if (!(state = targetWorld.getBlockState((BlockPos)pair.getLeft())).isAir() && this.canBreak((Level)targetWorld, (BlockPos)pair.getLeft(), state)) {
                this.breakOneBlock((BlockPos)pair.getLeft(), false);
            }
            targetWorld.setBlock((BlockPos)pair.getLeft(), Holder.BLOCK_DUMMY.defaultBlockState(), 18);
        }
        toBreak.stream().flatMap(p -> Block.getDrops((BlockState)((BlockState)p.getRight()), (ServerLevel)targetWorld, (BlockPos)((BlockPos)p.getLeft()), (BlockEntity)targetWorld.getBlockEntity((BlockPos)p.getLeft()), (Entity)fakePlayer, (ItemStack)pickaxe).stream()).map(this.itemConverter::map).forEach(this.storage::addItem);
        toBreak.stream().map(Pair::getLeft).forEach(p -> targetWorld.setBlock(p, this.getReplacementState(), 18));
        if (exp.get() > 0) {
            this.getExpModule().ifPresent(e -> {
                this.useEnergy(PowerManager.getExpCollectEnergy(exp.get(), this), PowerTile.Reason.EXP_COLLECT, true);
                e.addExp(exp.get());
            });
        }
        this.setChanged();
        return BreakResult.SUCCESS;
    }

    void removeEdgeFluid(int x, int z, ServerLevel targetWorld) {
        boolean flagMaxZ;
        assert (this.area != null);
        boolean flagMinX = x - 1 == this.area.minX();
        boolean flagMaxX = x + 1 == this.area.maxX();
        boolean flagMinZ = z - 1 == this.area.minZ();
        boolean bl = flagMaxZ = z + 1 == this.area.maxZ();
        if (flagMinX) {
            this.removeFluidAtXZ(this.area.minX(), z, targetWorld);
        }
        if (flagMaxX) {
            this.removeFluidAtXZ(this.area.maxX(), z, targetWorld);
        }
        if (flagMinZ) {
            this.removeFluidAtXZ(x, this.area.minZ(), targetWorld);
        }
        if (flagMaxZ) {
            this.removeFluidAtXZ(x, this.area.maxZ(), targetWorld);
        }
        if (flagMinX && flagMinZ) {
            this.removeFluidAtXZ(this.area.minX(), this.area.minZ(), targetWorld);
        }
        if (flagMinX && flagMaxZ) {
            this.removeFluidAtXZ(this.area.minX(), this.area.maxZ(), targetWorld);
        }
        if (flagMaxX && flagMinZ) {
            this.removeFluidAtXZ(this.area.maxX(), this.area.minZ(), targetWorld);
        }
        if (flagMaxX && flagMaxZ) {
            this.removeFluidAtXZ(this.area.maxX(), this.area.maxZ(), targetWorld);
        }
    }

    void removeFluidAtXZ(int x, int z, ServerLevel world) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, 0, z);
        for (int y = this.getBlockPos().getY() - 1; y > this.digMinY; --y) {
            pos.setY(y);
            FluidState fluidState = world.getFluidState((BlockPos)pos);
            if (fluidState.isEmpty()) continue;
            BlockState state = world.getBlockState((BlockPos)pos);
            Block block = state.getBlock();
            if (block instanceof BucketPickup) {
                BucketPickup fluidBlock = (BucketPickup)block;
                this.useEnergy(PowerManager.getBreakBlockFluidEnergy(this), PowerTile.Reason.REMOVE_FLUID, true);
                ItemStack bucketItem = fluidBlock.pickupBlock((LevelAccessor)world, (BlockPos)pos, state);
                this.storage.addFluid(bucketItem);
                if (!world.getBlockState((BlockPos)pos).isAir() && (!(fluidBlock instanceof LiquidBlock) || fluidState.isSource())) continue;
                world.setBlock((BlockPos)pos, Holder.BLOCK_FRAME.getDammingState(), 3);
                continue;
            }
            if (!(state.getBlock() instanceof LiquidBlockContainer)) continue;
            float hardness = state.getDestroySpeed((BlockGetter)world, (BlockPos)pos);
            this.useEnergy(PowerManager.getBreakEnergy(hardness, this), PowerTile.Reason.REMOVE_FLUID, true);
            List drops = Block.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)pos, (BlockEntity)world.getBlockEntity((BlockPos)pos), null, (ItemStack)this.getPickaxe());
            drops.forEach(this.storage::addItem);
            world.setBlock((BlockPos)pos, Holder.BLOCK_FRAME.getDammingState(), 3);
        }
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    void openModuleGui(ServerPlayer player) {
        ContainerQuarryModule.InteractionObject.openGUI(this, player, this.getDisplayName());
    }

    @Override
    public int efficiencyLevel() {
        return this.cache.enchantments.getValue(this.getLevel()).efficiency();
    }

    @Override
    public int unbreakingLevel() {
        return this.cache.enchantments.getValue(this.getLevel()).unbreaking();
    }

    @Override
    public int fortuneLevel() {
        return this.cache.enchantments.getValue(this.getLevel()).fortune();
    }

    @Override
    public int silktouchLevel() {
        return this.cache.enchantments.getValue(this.getLevel()).silktouch();
    }

    private class QuarryCache {
        final CacheEntry<BlockState> replaceState = CacheEntry.supplierCache(5L, () -> TileAdvQuarry.this.getReplacerModule().map(ReplacerModule::getState).orElse(Blocks.AIR.defaultBlockState()));
        final CacheEntry<Integer> netherTop = CacheEntry.supplierCache(100L, () -> ((ForgeConfigSpec.IntValue)QuarryPlus.config.common.netherTop).get());
        final CacheEntry<EnchantmentHolder> enchantments = CacheEntry.supplierCache(1000L, () -> EnchantmentHolder.makeHolder(TileAdvQuarry.this));
    }
}

