/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.bookmover;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.bookmover.BookMoverEntity;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class BookMoverBlock
extends QPBlock
implements EntityBlock {
    public static final String NAME = "book_mover";
    public static final String GUI_ID = "quarryplus:gui_book_mover";

    public BookMoverBlock() {
        super(BlockBehaviour.Properties.of((Material)Material.METAL).strength(1.2f), NAME);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!world.isClientSide) {
                player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.getName()}), true);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        if (!player.isShiftKeyDown()) {
            BlockEntity blockEntity;
            if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof BookMoverEntity) {
                BookMoverEntity mover = (BookMoverEntity)blockEntity;
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)mover, (BlockPos)pos);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BookMoverEntity) {
                BookMoverEntity mover = (BookMoverEntity)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)mover);
            }
            super.onRemove(state, level, pos, newState, moved);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Holder.BOOK_MOVER_TYPE.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BookMoverBlock.checkType(type, Holder.BOOK_MOVER_TYPE, new CombinedBlockEntityTicker(PowerTile.getGenerator(), (l, p, s, t) -> t.workInTick(), PowerTile.logTicker()));
    }
}

