/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.bookmover;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantableItem;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.bookmover.BookMoverMenu;
import com.yogpc.qp.utils.MapMulti;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.VisibleForTesting;

public class BookMoverEntity
extends PowerTile
implements Container,
MenuProvider,
CheckerLog {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    static final Set<EnchantmentCategory> CATEGORIES = Arrays.stream(EnchantmentCategory.values()).filter(t -> t.canEnchant(Items.DIAMOND_PICKAXE)).collect(Collectors.toSet());
    static final Set<Enchantment> VALID_ENCHANTMENTS = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(e -> CATEGORIES.contains(e.category)).collect(Collectors.toSet());

    public BookMoverEntity(BlockPos pos, BlockState state) {
        super(Holder.BOOK_MOVER_TYPE, pos, state);
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory);
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory);
    }

    void workInTick() {
        if (!this.hasEnoughEnergy() || !this.isWorking()) {
            return;
        }
        if (this.getEnergy() >= this.getMaxEnergy()) {
            if (!this.canPlaceItem(0, (ItemStack)this.inventory.get(0)) || !this.canPlaceItem(1, (ItemStack)this.inventory.get(1))) {
                return;
            }
            Map enchantments = EnchantmentHelper.getEnchantments((ItemStack)((ItemStack)this.inventory.get(1)));
            enchantments.entrySet().stream().filter(e -> VALID_ENCHANTMENTS.contains(e.getKey()) && EnchantmentHelper.getEnchantments((ItemStack)((ItemStack)this.inventory.get(0))).keySet().stream().allMatch(e2 -> e2 == e.getKey() || e2.isCompatibleWith((Enchantment)e.getKey())) && EnchantmentHelper.getItemEnchantmentLevel((Enchantment)((Enchantment)e.getKey()), (ItemStack)((ItemStack)this.inventory.get(0))) < (Integer)e.getValue()).findFirst().ifPresent(e -> {
                ItemStack copy = ((ItemStack)this.inventory.get(0)).copy();
                BookMoverEntity.removeEnchantment((Enchantment)e.getKey(), copy);
                copy.enchant((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue());
                if (enchantments.size() == 1) {
                    this.setItem(1, new ItemStack((ItemLike)Items.BOOK));
                } else {
                    BookMoverEntity.removeEnchantment((Enchantment)e.getKey(), (ItemStack)this.inventory.get(1));
                }
                this.setItem(0, ItemStack.EMPTY);
                this.setItem(2, copy);
                this.useEnergy(this.getMaxEnergy(), PowerTile.Reason.BOOK_MOVER, false);
            });
        }
    }

    @Override
    protected long getMaxReceive() {
        if (this.isWorking()) {
            return this.getMaxEnergy() / 300L;
        }
        return 0L;
    }

    public int getContainerSize() {
        return 3;
    }

    public boolean isEmpty() {
        return this.inventory.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.inventory, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.inventory, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        this.setChanged();
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return switch (index) {
            case 0 -> stack.getItem() instanceof EnchantableItem;
            case 1 -> {
                if (stack.getItem() == Items.ENCHANTED_BOOK) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    public boolean stillValid(Player player) {
        return BookMoverEntity.stillValid(this, player);
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of(this.energyString()).map(TextComponent::new).toList();
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new BookMoverMenu(id, player, this.getBlockPos());
    }

    boolean isWorking() {
        return !((ItemStack)this.inventory.get(0)).isEmpty() && !((ItemStack)this.inventory.get(1)).isEmpty();
    }

    @VisibleForTesting
    static void removeEnchantment(Enchantment enchantment, ItemStack stack) {
        String tagName;
        ListTag list;
        if (stack.is(Items.ENCHANTED_BOOK)) {
            list = EnchantedBookItem.getEnchantments((ItemStack)stack);
            tagName = "StoredEnchantments";
        } else {
            list = stack.getEnchantmentTags();
            tagName = "Enchantments";
        }
        stack.removeTagKey(tagName);
        ListTag newList = list.stream().mapMulti(MapMulti.cast(CompoundTag.class)).filter(t -> !Objects.equals(EnchantmentHelper.getEnchantmentId((CompoundTag)t), enchantment.getRegistryName())).collect(Collectors.toCollection(ListTag::new));
        stack.addTagElement(tagName, (Tag)newList);
    }
}

