/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.bookmover;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.bookmover.BookMoverEntity;
import com.yogpc.qp.machines.misc.SlotContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BookMoverMenu
extends AbstractContainerMenu {
    private final BookMoverEntity mover;
    private final DataSlot progress = this.addDataSlot(DataSlot.standalone());
    private final DataSlot isWorking = this.addDataSlot(DataSlot.standalone());

    public BookMoverMenu(int id, Player player, BlockPos pos) {
        super(Holder.BOOK_MOVER_MENU_TYPE, id);
        this.mover = (BookMoverEntity)player.level.getBlockEntity(pos);
        if (this.mover != null) {
            this.addSlot(new SlotContainer(this.mover, 0, 13, 35));
            this.addSlot(new SlotContainer(this.mover, 1, 55, 35));
            this.addSlot(new SlotContainer(this.mover, 2, 116, 35));
            if (!player.level.isClientSide) {
                this.setTrackValues();
            }
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)player.getInventory(), j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)player.getInventory(), k, 8 + k * 18, 142));
        }
    }

    private void setTrackValues() {
        this.progress.set(1000 * this.mover.getEnergyStored() / this.mover.getMaxEnergyStored());
        this.isWorking.set(this.mover.isWorking() ? 1 : 0);
    }

    public boolean stillValid(Player playerIn) {
        return this.mover.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int allSlots = 3;
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack remain = slot.getItem();
            ItemStack slotContent = remain.copy();
            if (index < allSlots ? !this.moveItemStackTo(remain, allSlots, 36 + allSlots, true) : !this.moveItemStackTo(remain, 0, allSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (remain.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (remain.getCount() == slotContent.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, remain);
            return slotContent;
        }
        return ItemStack.EMPTY;
    }

    public void broadcastChanges() {
        this.setTrackValues();
        super.broadcastChanges();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progress.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean moverIsWorking() {
        return this.isWorking.get() == 1;
    }
}

