/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.checker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QPItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemChecker
extends QPItem {
    public static final String NAME = "status_checker";

    public ItemChecker() {
        super(new Item.Properties().tab(Holder.TAB));
        this.setRegistryName("quarryplus", NAME);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockEntity blockEntity;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        if (player != null && (blockEntity = level.getBlockEntity(context.getClickedPos())) instanceof CheckerLog) {
            CheckerLog debug = (CheckerLog)blockEntity;
            List<? extends Component> logs = debug.getDebugLogs();
            if (logs != null) {
                player.displayClientMessage((Component)new TextComponent(String.valueOf(ChatFormatting.YELLOW) + (level.isClientSide ? "Client" : "Server") + String.valueOf(ChatFormatting.RESET)), false);
                logs.forEach(t -> player.displayClientMessage(t, false));
            } else {
                QuarryPlus.LOGGER.warn("CheckerLog implementation was insufficient. " + String.valueOf(debug.getClass()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

