/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.controller;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.controller.ControllerOpenMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.MapMulti;
import cpw.mods.modlauncher.Launcher;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class BlockController
extends QPBlock {
    public static final String NAME = "spawner_controller";
    private static final Logger LOGGER = QuarryPlus.getLogger(BlockController.class);
    private static final Field logic_spawnDelay = BlockController.getSpawnDelayField();
    private static final Field logic_nextSpawnData = BlockController.getNextSpawnDataField();

    public BlockController() {
        super(BlockBehaviour.Properties.of((Material)Material.DECORATION).strength(1.0f), NAME);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WORKING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WORKING});
    }

    private static Optional<Pair<BaseSpawner, BlockPos>> getSpawner(Level level, BlockPos pos) {
        return Stream.of(Direction.values()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).map(arg_0 -> ((Level)level).getBlockEntity(arg_0)).mapMulti(MapMulti.cast(SpawnerBlockEntity.class)).map(s -> Pair.of((Object)s.getSpawner(), (Object)s.getBlockPos())).findFirst();
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!level.isClientSide) {
                player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.getName()}), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                if (player.getItemInHand(hand).is((Item)Holder.ITEM_CHECKER)) {
                    BlockController.getSpawner(level, pos).map(Pair::getLeft).flatMap(BlockController::getEntityId).map(ResourceLocation::toString).map(s -> "Spawner Mob: " + s).map(TextComponent::new).ifPresent(s -> player.displayClientMessage((Component)s, false));
                } else {
                    List<ResourceLocation> entries = ForgeRegistries.ENTITIES.getValues().stream().filter(BlockController::canSpawnFromSpawner).map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toList());
                    PacketHandler.sendToClientPlayer(new ControllerOpenMessage(pos, (ResourceKey<Level>)level.dimension(), entries), (ServerPlayer)player);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private static Optional<ResourceLocation> getEntityId(BaseSpawner spawner) {
        try {
            return Optional.ofNullable(logic_nextSpawnData.get(spawner)).flatMap(MapMulti.optCast(SpawnData.class)).map(SpawnData::getEntityToSpawn).flatMap(EntityType::by).map(ForgeRegistryEntry::getRegistryName);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Exception occurred in getting entity id.", (Throwable)e);
            return Optional.empty();
        }
    }

    private static boolean canSpawnFromSpawner(EntityType<?> entityType) {
        if (QuarryPlus.config == null) {
            return true;
        }
        if (!entityType.canSummon()) {
            return false;
        }
        return !((List)QuarryPlus.config.common.spawnerBlackList.get()).contains(String.valueOf(entityType.getRegistryName()));
    }

    public static void setSpawnerEntity(Level world, BlockPos pos, ResourceLocation name) {
        BlockController.getSpawner(world, pos).ifPresent(logic -> {
            Optional.of(name).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITIES).getValue(arg_0)).filter(BlockController::canSpawnFromSpawner).ifPresent(arg_0 -> ((BaseSpawner)((BaseSpawner)logic.getLeft())).setEntityId(arg_0));
            Optional.ofNullable(((BaseSpawner)logic.getLeft()).getSpawnerBlockEntity()).ifPresent(BlockEntity::setChanged);
            BlockState state = world.getBlockState((BlockPos)logic.getRight());
            world.sendBlockUpdated((BlockPos)logic.getRight(), state, state, 4);
        });
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide && QuarryPlus.config.enableMap.enabled(NAME)) {
            boolean powered = level.hasNeighborSignal(pos);
            boolean m = (Boolean)state.getValue((Property)QPBlock.WORKING);
            if (powered && !m) {
                BlockController.getSpawner(level, pos).ifPresent(logic -> {
                    try {
                        logic_spawnDelay.setInt(logic.getLeft(), 0);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return;
                    }
                    FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
                    fakePlayer.setLevel((ServerLevel)level);
                    fakePlayer.setPos((double)((BlockPos)logic.getRight()).getX(), (double)((BlockPos)logic.getRight()).getY(), (double)((BlockPos)logic.getRight()).getZ());
                    ((BaseSpawner)logic.getLeft()).serverTick((ServerLevel)level, (BlockPos)logic.getRight());
                });
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)QPBlock.WORKING, (Comparable)Boolean.valueOf(powered)), 3);
        }
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
    }

    private static Field getSpawnDelayField() {
        if (Launcher.INSTANCE != null) {
            return ObfuscationReflectionHelper.findField(BaseSpawner.class, (String)"f_45442_");
        }
        try {
            Field f = BaseSpawner.class.getDeclaredField("spawnDelay");
            f.setAccessible(true);
            return f;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getNextSpawnDataField() {
        if (Launcher.INSTANCE != null) {
            return ObfuscationReflectionHelper.findField(BaseSpawner.class, (String)"f_45444_");
        }
        try {
            Field f = BaseSpawner.class.getDeclaredField("nextSpawnData");
            f.setAccessible(true);
            return f;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

