/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.controller;

import com.yogpc.qp.machines.controller.GuiController;
import com.yogpc.qp.packet.IMessage;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public final class ControllerOpenMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final List<ResourceLocation> allEntities;

    public ControllerOpenMessage(BlockPos pos, ResourceKey<Level> dim, List<ResourceLocation> allEntities) {
        this.pos = pos;
        this.dim = dim;
        this.allEntities = allEntities;
    }

    public ControllerOpenMessage(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.dim = ResourceKey.create((ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)buf.readResourceLocation());
        int size = buf.readInt();
        this.allEntities = Stream.generate(() -> ((FriendlyByteBuf)buf).readResourceLocation()).limit(size).toList();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos).writeResourceLocation(this.dim.location());
        buf.writeInt(this.allEntities.size());
        this.allEntities.forEach(arg_0 -> ((FriendlyByteBuf)buf).writeResourceLocation(arg_0));
    }

    public static void onReceive(ControllerOpenMessage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ControllerOpenMessage.openScreen(message));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openScreen(ControllerOpenMessage message) {
        Minecraft.getInstance().setScreen((Screen)new GuiController(message.dim, message.pos, message.allEntities));
    }
}

