/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.controller;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.controller.GuiSlotEntities;
import com.yogpc.qp.machines.controller.SetSpawnerEntityMessage;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GuiController
extends Screen
implements Button.OnPress {
    private static final Comparator<ResourceLocation> RESOURCE_LOCATION_COMPARATOR = Comparator.comparing(ResourceLocation::getNamespace).thenComparing(ResourceLocation::getPath);
    private GuiSlotEntities slot;
    private EditBox search;
    List<ResourceLocation> names;
    @NotNull
    private final List<ResourceLocation> allEntities;
    private final ResourceKey<Level> dim;
    private final BlockPos pos;

    public GuiController(ResourceKey<Level> dim, BlockPos pos, List<ResourceLocation> allEntities) {
        super((Component)Holder.BLOCK_CONTROLLER.getName());
        this.dim = dim;
        this.pos = pos;
        this.allEntities = allEntities;
        this.names = allEntities.stream().sorted(RESOURCE_LOCATION_COMPARATOR).collect(Collectors.toList());
    }

    public void init() {
        super.init();
        int width = this.width;
        int height = this.height;
        this.slot = new GuiSlotEntities(this.getMinecraft(), width, height, 30, height - 60, 18, this);
        this.addRenderableWidget((GuiEventListener)this.slot);
        this.setInitialFocus((GuiEventListener)this.slot);
        this.addRenderableWidget((GuiEventListener)new IndexedButton(-1, width / 2 - 125, height - 26, 250, 20, (Component)new TranslatableComponent("gui.done"), this));
        this.search = new EditBox(this.font, width / 2 - 125, height - 56, 250, 20, (Component)new TextComponent("edit box"));
        this.addRenderableWidget((GuiEventListener)this.search);
        this.search.setCanLoseFocus(true);
        this.search.setResponder(this::searchEntities);
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.slot != null) {
            this.slot.render(matrixStack, mouseX, mouseY, partialTicks);
            this.search.render(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        GuiController.drawCenteredString((PoseStack)matrixStack, (Font)this.font, (Component)new TranslatableComponent("yog.spawner.setting"), (int)(this.width / 2), (int)8, (int)0xFFFFFF);
    }

    public void tick() {
        super.tick();
        if (this.getMinecraft().player != null && !this.getMinecraft().player.isAlive()) {
            this.getMinecraft().player.closeContainer();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (keyCode == 256 || !this.search.isFocused() && this.getMinecraft().options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onPress(Button button) {
        IndexedButton indexedButton;
        if (button instanceof IndexedButton && (indexedButton = (IndexedButton)button).id() == -1) {
            GuiSlotEntities.Entry selected = (GuiSlotEntities.Entry)this.slot.getSelected();
            if (selected != null) {
                PacketHandler.sendToServer(new SetSpawnerEntityMessage(this.pos, this.dim, selected.location));
            }
            if (this.getMinecraft().player != null) {
                this.getMinecraft().player.closeContainer();
            }
        }
    }

    public void buildModList(Consumer<GuiSlotEntities.Entry> modListViewConsumer, Function<ResourceLocation, GuiSlotEntities.Entry> newEntry) {
        this.names.stream().map(newEntry).forEach(modListViewConsumer);
    }

    public void searchEntities(String text) {
        List collect;
        if (!text.isEmpty()) {
            try {
                Pattern pattern = Pattern.compile(text);
                collect = this.allEntities.stream().filter(l -> pattern.matcher(l.toString()).find()).sorted(RESOURCE_LOCATION_COMPARATOR).collect(Collectors.toList());
            }
            catch (PatternSyntaxException e) {
                collect = this.allEntities.stream().filter(l -> l.toString().contains(text)).sorted(RESOURCE_LOCATION_COMPARATOR).collect(Collectors.toList());
            }
        } else {
            collect = this.allEntities.stream().sorted(RESOURCE_LOCATION_COMPARATOR).collect(Collectors.toList());
        }
        if (this.names.size() != collect.size()) {
            this.slot.setScrollAmount(0.0);
        }
        this.names = collect;
        this.slot.refreshList();
        this.slot.setSelected(null);
    }
}

