/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.controller;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.controller.GuiController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class GuiSlotEntities
extends ObjectSelectionList<Entry> {
    private final GuiController parent;

    public GuiSlotEntities(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn, GuiController parent) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.parent = parent;
        this.refreshList();
    }

    public void refreshList() {
        this.clearEntries();
        this.parent.buildModList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), x$0 -> new Entry((ResourceLocation)x$0));
    }

    final class Entry
    extends ObjectSelectionList.Entry<Entry> {
        public final ResourceLocation location;

        public Entry(ResourceLocation location) {
            this.location = location;
        }

        public void render(PoseStack matrix, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            String name = this.location.toString();
            Minecraft minecraft = Minecraft.getInstance();
            assert (minecraft.screen != null);
            minecraft.font.draw(matrix, name, (float)(minecraft.screen.width - minecraft.font.width(name) >> 1), (float)(top + 2), 0xFFFFFF);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            GuiSlotEntities.this.setSelected((AbstractSelectionList.Entry)this);
            return false;
        }

        public Component getNarration() {
            return new TranslatableComponent("narrator.select", new Object[]{this.location});
        }
    }
}

