/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.filler.SkipIterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class FillerAction {
    private static final Logger LOGGER = QuarryPlus.getLogger(FillerAction.class);
    @Nullable
    SkipIterator iterator = null;

    public void tick(Supplier<Optional<ItemStack>> stackProvider, PowerTile powerSource, long energy) {
        if (this.iterator == null || powerSource.getLevel() == null) {
            return;
        }
        Optional<ItemStack> maybeStack = stackProvider.get();
        Level level = powerSource.getLevel();
        maybeStack.ifPresent(blockStack -> {
            BlockPos targetPos = this.iterator.peek(FillerAction.predicate(level, blockStack));
            if (targetPos == null) {
                this.iterator = null;
            } else if (powerSource.useEnergy(energy, PowerTile.Reason.FILLER, false)) {
                BlockPlaceContext context = FillerAction.createContext(level, targetPos, blockStack);
                BlockState state = FillerAction.getStateFromItem((BlockItem)blockStack.getItem(), context);
                if (state != null) {
                    level.setBlock(targetPos, state, 3);
                    blockStack.shrink(1);
                }
                this.iterator.commit(targetPos, false);
            }
        });
    }

    public void tick(Level level, PowerTile powerSource, long energy) {
        if (this.iterator == null || powerSource.getLevel() == null) {
            return;
        }
        BlockPos targetPos = this.iterator.peek(FillerAction.predicate(level));
        if (targetPos == null) {
            this.iterator = null;
        } else {
            BlockState toPlace = FillerAction.getToReplace((ResourceKey<Level>)level.dimension(), targetPos);
            if (powerSource.useEnergy(energy, PowerTile.Reason.FILLER, false)) {
                level.setBlock(targetPos, toPlace, 3);
                this.iterator.commit(targetPos, false);
            }
        }
    }

    public boolean isFinished() {
        return this.iterator == null;
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        if (this.iterator != null) {
            tag.put("iterator", (Tag)this.iterator.toNbt());
        }
        return tag;
    }

    public void fromNbt(CompoundTag tag) {
        if (tag.contains("iterator")) {
            this.iterator = SkipIterator.fromNbt(tag.getCompound("iterator"));
        }
    }

    public void setIterator(@Nullable SkipIterator iterator) {
        this.iterator = iterator;
    }

    private static Predicate<BlockPos> predicate(Level level, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return pos -> {
                BlockPlaceContext context = FillerAction.createContext(level, pos, stack);
                BlockState state = FillerAction.getStateFromItem(blockItem, context);
                if (!context.getClickedPos().equals(pos)) {
                    return false;
                }
                if (!context.canPlace() || state == null) {
                    return false;
                }
                return level.isUnobstructed(state, pos, CollisionContext.empty());
            };
        }
        return pos -> false;
    }

    private static Predicate<BlockPos> predicate(Level level) {
        return pos -> {
            BlockState state = FillerAction.getToReplace((ResourceKey<Level>)level.dimension(), pos);
            ItemStack stack = new ItemStack((ItemLike)state.getBlock());
            DirectionalPlaceContext context = new DirectionalPlaceContext(level, pos, Direction.DOWN, stack, Direction.UP);
            if (!context.canPlace()) {
                return false;
            }
            return level.isUnobstructed(state, pos, CollisionContext.empty());
        };
    }

    static BlockPlaceContext createContext(Level level, BlockPos pos, ItemStack stack) {
        return new BlockPlaceContext(level, null, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.atBottomCenterOf((Vec3i)pos), Direction.UP, pos, false));
    }

    @Nullable
    private static BlockState getStateFromItem(BlockItem blockItem, BlockPlaceContext context) {
        try {
            return (BlockState)ObfuscationReflectionHelper.findMethod(BlockItem.class, (String)"m_5965_", (Class[])new Class[]{BlockPlaceContext.class}).invoke((Object)blockItem, context);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Caught exception in Filler", (Throwable)e);
            return null;
        }
    }

    public static BlockState getToReplace(ResourceKey<Level> dimension, BlockPos pos) {
        if (dimension.equals((Object)Level.NETHER)) {
            return Blocks.NETHERRACK.defaultBlockState();
        }
        if (dimension.equals((Object)Level.END)) {
            return Blocks.END_STONE.defaultBlockState();
        }
        if (dimension.equals((Object)Level.OVERWORLD)) {
            if (pos.getY() >= 0) {
                return Blocks.STONE.defaultBlockState();
            }
            return Blocks.DEEPSLATE.defaultBlockState();
        }
        return Blocks.STONE.defaultBlockState();
    }
}

