/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.filler.FillerEntity;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public final class FillerBlock
extends QPBlock
implements EntityBlock {
    public static final String NAME = "filler";

    public FillerBlock() {
        super(BlockBehaviour.Properties.of((Material)Material.METAL).strength(1.5f, 10.0f).sound(SoundType.STONE), NAME);
    }

    public FillerEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return (FillerEntity)Holder.FILLER_TYPE.create(pPos, pState);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        if (!level.isClientSide && level.hasNeighborSignal(pos)) {
            level.getBlockEntity(pos, Holder.FILLER_TYPE).ifPresent(f -> f.start(FillerEntity.Action.BOX));
        }
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!level.isClientSide) {
                player.displayClientMessage((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.getName()}), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!player.isShiftKeyDown()) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof FillerEntity) {
                FillerEntity filler = (FillerEntity)blockEntity;
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)filler, (BlockPos)pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.use(state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide) {
            level.getBlockEntity(pos, Holder.FILLER_TYPE).ifPresent(t -> {
                boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos, t.enabled);
                t.setChunkPreLoaded(preForced);
            });
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FillerEntity) {
                FillerEntity filler = (FillerEntity)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)filler.container);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, moved);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> entityType) {
        return pLevel.isClientSide ? null : FillerBlock.checkType(entityType, Holder.FILLER_TYPE, new CombinedBlockEntityTicker(PowerTile.getGenerator(), (l, p, s, t) -> t.tick(), PowerTile.logTicker()));
    }
}

