/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.machines.filler.FillerEntity;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.MapMulti;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public final class FillerButtonMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final FillerEntity.Action action;

    FillerButtonMessage(FillerEntity filler, FillerEntity.Action action) {
        this.pos = filler.getBlockPos();
        this.dim = PacketHandler.getDimension(filler);
        this.action = action;
    }

    public FillerButtonMessage(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.dim = ResourceKey.create((ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)buf.readResourceLocation());
        this.action = (FillerEntity.Action)buf.readEnum(FillerEntity.Action.class);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos).writeResourceLocation(this.dim.location());
        buf.writeEnum((Enum)this.action);
    }

    public static void onReceive(FillerButtonMessage message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> world = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> world.map(w -> w.getBlockEntity(message.pos)).flatMap(MapMulti.optCast(FillerEntity.class)).ifPresent(arg_0 -> FillerButtonMessage.lambda$onReceive$2(message, (Supplier)supplier, arg_0)));
    }

    private static /* synthetic */ void lambda$onReceive$2(FillerButtonMessage message, Supplier supplier, FillerEntity f) {
        f.start(message.action);
        if (f.fillerAction.isFinished()) {
            PacketHandler.getPlayer((NetworkEvent.Context)supplier.get()).ifPresent(p -> p.displayClientMessage((Component)new TextComponent("Filler work isn't started. You must place a marker near Filler."), false));
        }
    }
}

