/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.PowerConfig;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.machines.filler.FillerAction;
import com.yogpc.qp.machines.filler.FillerContainer;
import com.yogpc.qp.machines.filler.FillerMenu;
import com.yogpc.qp.machines.filler.FillerTargetPosIterator;
import com.yogpc.qp.machines.filler.SkipIterator;
import com.yogpc.qp.utils.MapMulti;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FillerEntity
extends PowerTile
implements CheckerLog,
PowerConfig.Provider,
MenuProvider {
    private static final Logger LOGGER = QuarryPlus.getLogger(FillerEntity.class);
    final FillerContainer container = new FillerContainer(27);
    LazyOptional<IItemHandler> handler = this.container.createHandler();
    final FillerAction fillerAction = new FillerAction();

    public FillerEntity(@NotNull BlockPos pos, BlockState state) {
        super(Holder.FILLER_TYPE, pos, state);
    }

    @Override
    protected void saveNbtData(CompoundTag nbt) {
        if (!this.fillerAction.isFinished()) {
            nbt.put("fillerAction", (Tag)this.fillerAction.toNbt());
        }
        nbt.put("container", (Tag)this.container.createTag());
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        if (nbt.contains("fillerAction")) {
            this.fillerAction.fromNbt(nbt.getCompound("fillerAction"));
        }
        this.container.fromTag(nbt.getList("container", 10));
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("Iterator: %s".formatted(this.fillerAction.iterator), this.energyString()).map(TextComponent::new).toList();
    }

    void tick() {
        if (!this.fillerAction.isFinished() && this.hasEnoughEnergy()) {
            if (this.level == null) {
                LOGGER.error("Level is NULL in {}#tick at {}", (Object)this.getClass().getSimpleName(), (Object)this.getBlockPos());
                return;
            }
            long energy = PowerManager.getFillerEnergy(this);
            this.fillerAction.tick(this.container::getFirstItem, (PowerTile)this, energy);
            if (this.fillerAction.isFinished()) {
                this.logUsage();
            }
        }
    }

    void start(Action fillerAction) {
        if (!this.fillerAction.isFinished()) {
            return;
        }
        assert (this.level != null);
        Stream.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).map(arg_0 -> ((BlockPos)this.getBlockPos()).relative(arg_0)).map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).mapMulti(MapMulti.cast(QuarryMarker.class)).findFirst().ifPresent(m -> {
            this.fillerAction.setIterator(m.getArea().map(a -> new SkipIterator((Area)a, fillerAction.iteratorProvider)).orElse(null));
            m.removeAndGetItems().forEach(stack -> Block.popResource((Level)this.level, (BlockPos)this.getBlockPos().above(), (ItemStack)stack));
        });
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    @Override
    public void reviveCaps() {
        super.reviveCaps();
        this.handler = this.container.createHandler();
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new FillerMenu(pContainerId, pPlayer, this.getBlockPos());
    }

    public static enum Action {
        BOX(FillerTargetPosIterator.Box::new),
        WALL(FillerTargetPosIterator.Wall::new),
        PILLAR(FillerTargetPosIterator.Pillar::new);

        final Function<Area, FillerTargetPosIterator> iteratorProvider;

        private Action(Function<Area, FillerTargetPosIterator> iteratorProvider) {
            this.iteratorProvider = iteratorProvider;
        }
    }
}

