/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.filler.FillerEntity;
import com.yogpc.qp.machines.misc.SlotContainer;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class FillerMenu
extends AbstractContainerMenu {
    public static final String GUI_ID = "quarryplus:gui_filler";
    @NotNull
    final FillerEntity filler;

    public FillerMenu(int id, Player player, BlockPos pos) {
        super(Holder.FILLER_MENU_TYPE, id);
        int v;
        int h;
        this.filler = (FillerEntity)Objects.requireNonNull(player.level.getBlockEntity(pos));
        int oneBox = 18;
        for (h = 0; h < 3; ++h) {
            for (v = 0; v < 9; ++v) {
                this.addSlot(new SlotContainer((Container)this.filler.container, v + h * 9, 8 + v * oneBox, 72 + h * oneBox));
            }
        }
        for (h = 0; h < 3; ++h) {
            for (v = 0; v < 9; ++v) {
                this.addSlot(new Slot((Container)player.getInventory(), v + h * 9 + 9, 8 + v * oneBox, 140 + h * oneBox));
            }
        }
        for (int vertical = 0; vertical < 9; ++vertical) {
            this.addSlot(new Slot((Container)player.getInventory(), vertical, 8 + vertical * oneBox, 198));
        }
    }

    public boolean stillValid(Player player) {
        return this.filler.getBlockPos().distToCenterSqr((Position)player.position()) < 64.0;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int allSlots = this.filler.container.getContainerSize();
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack remain = slot.getItem();
            ItemStack slotContent = remain.copy();
            if (index < allSlots ? !this.moveItemStackTo(remain, allSlots, 36 + allSlots, true) : !this.moveItemStackTo(remain, 0, allSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (remain.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (remain.getCount() == slotContent.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, remain);
            return slotContent;
        }
        return ItemStack.EMPTY;
    }
}

