/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.filler.FillerButtonMessage;
import com.yogpc.qp.machines.filler.FillerEntity;
import com.yogpc.qp.machines.filler.FillerMenu;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.packet.PacketHandler;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class FillerScreen
extends AbstractContainerScreen<FillerMenu>
implements Button.OnPress {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/filler.png");

    public FillerScreen(FillerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 176;
        this.imageHeight = 222;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        AtomicInteger id = new AtomicInteger(0);
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), this.getGuiLeft() + this.getXSize() - 60 - 8, this.getGuiTop() + 7, 60, 20, (Component)new TextComponent("FillAll"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), this.getGuiLeft() + this.getXSize() - 60 - 8, this.getGuiTop() + 7 + 20, 60, 20, (Component)new TextComponent("FillBox"), this));
    }

    protected void renderBg(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION);
        this.blit(pPoseStack, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        this.renderTooltip(matrices, mouseX, mouseY);
    }

    public void onPress(Button pButton) {
        if (pButton instanceof IndexedButton) {
            IndexedButton indexedButton = (IndexedButton)pButton;
            switch (indexedButton.getIndex()) {
                case 0: {
                    PacketHandler.sendToServer(new FillerButtonMessage(((FillerMenu)this.menu).filler, FillerEntity.Action.BOX));
                    break;
                }
                case 1: {
                    PacketHandler.sendToServer(new FillerButtonMessage(((FillerMenu)this.menu).filler, FillerEntity.Action.WALL));
                    break;
                }
                case 2: {
                    PacketHandler.sendToServer(new FillerButtonMessage(((FillerMenu)this.menu).filler, FillerEntity.Action.PILLAR));
                    break;
                }
                default: {
                    QuarryPlus.LOGGER.error("Unknown button({}, {}) is pushed in {}", (Object)indexedButton, (Object)indexedButton.getIndex(), (Object)this);
                    break;
                }
            }
        } else {
            QuarryPlus.LOGGER.error("Unknown button({}) is pushed in {}", (Object)pButton, (Object)this);
        }
    }
}

