/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.marker.BlockWaterloggedMarker;
import com.yogpc.qp.machines.marker.ContainerMarker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public abstract class BlockExMarker
extends QPBlock
implements EntityBlock {
    private static final VoxelShape STANDING_Shape = Shapes.box((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    public static final String GUI_FLEX_ID = "quarryplus:gui_flex_marker";
    public static final String GUI_16_ID = "quarryplus:gui_marker16";

    protected BlockExMarker(BlockBehaviour.Properties properties, String name) {
        super(properties, name);
    }

    protected abstract void openGUI(Level var1, BlockPos var2, Player var3);

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.isShiftKeyDown()) {
            if (!world.isClientSide) {
                this.openGUI(world, pos, player);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return STANDING_Shape;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = Direction.UP;
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos currentPos, BlockPos neighborPos) {
        return state.canSurvive((LevelReader)world, currentPos) ? state : Blocks.AIR.defaultBlockState();
    }

    public abstract void setPlacedBy(Level var1, BlockPos var2, BlockState var3, @Nullable LivingEntity var4, ItemStack var5);

    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    public static class Range {
        private final float min;
        private final float max;
        private final float distance;

        public Range(float min, float max) {
            this.min = min;
            this.max = max;
            if (max < min) {
                throw new IllegalArgumentException(String.format("min is grater than max. Min: %f, Max:%f", Float.valueOf(min), Float.valueOf(max)));
            }
            this.distance = max - min;
        }

        public float convert(float f) {
            if (f < this.min) {
                int i = (int)((this.min - f) / this.distance) + 1;
                return this.convert(f + this.distance * (float)i);
            }
            if (f >= this.max) {
                int i = (int)((f - this.max) / this.distance) + 1;
                return this.convert(f - this.distance * (float)i);
            }
            return f;
        }
    }

    private record InteractionObject(BlockPos pos, MenuType<?> type, String name, int inventoryX, int inventoryY) implements MenuProvider
    {
        public Component getDisplayName() {
            return new TranslatableComponent(this.name);
        }

        public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
            return new ContainerMarker(syncId, player, this.pos, this.type, this.inventoryX, this.inventoryY);
        }
    }

    public static class BlockWaterlogged16Marker
    extends WaterloggedMarker {
        public static final String NAME = "waterlogged_marker16";

        public BlockWaterlogged16Marker() {
            super(BlockBehaviour.Properties.of((Material)Material.DECORATION), NAME);
        }

        @Override
        protected BlockExMarker getBaseBlock() {
            return Holder.BLOCK_16_MARKER;
        }
    }

    public static class Block16Marker
    extends BlockExMarker {
        private static final Range RANGE = new Range(0.0f, 360.0f);
        public static final String NAME = "marker16";

        public Block16Marker() {
            super(BlockBehaviour.Properties.of((Material)Material.DECORATION).lightLevel(value -> 7).noCollission(), NAME);
        }

        @Override
        protected void openGUI(Level worldIn, BlockPos pos, Player playerIn) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new InteractionObject(pos, Holder.MARKER_16_MENU_TYPE, this.getDescriptionId(), 29, 107), (BlockPos)pos);
        }

        @Override
        public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
            float angle = RANGE.convert(placer != null ? placer.getYHeadRot() : 0.0f);
            Direction.AxisDirection z = angle < 90.0f || angle >= 270.0f ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
            Direction.AxisDirection x = angle > 180.0f ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
            level.getBlockEntity(pos, Holder.MARKER_16_TYPE).ifPresent(t -> t.init(x, z));
        }

        @Override
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return Holder.MARKER_16_TYPE.create(pos, state);
        }
    }

    public static class BlockWaterloggedFlexMarker
    extends WaterloggedMarker {
        public static final String NAME = "waterlogged_flex_marker";

        public BlockWaterloggedFlexMarker() {
            super(BlockBehaviour.Properties.of((Material)Material.DECORATION), NAME);
        }

        @Override
        protected BlockExMarker getBaseBlock() {
            return Holder.BLOCK_FLEX_MARKER;
        }
    }

    public static class BlockFlexMarker
    extends BlockExMarker {
        public static final String NAME = "flex_marker";

        public BlockFlexMarker() {
            super(BlockBehaviour.Properties.of((Material)Material.DECORATION).lightLevel(value -> 7).noCollission(), NAME);
        }

        @Override
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return Holder.FLEX_MARKER_TYPE.create(pos, state);
        }

        @Override
        protected void openGUI(Level worldIn, BlockPos pos, Player playerIn) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new InteractionObject(pos, Holder.FLEX_MARKER_MENU_TYPE, this.getDescriptionId(), 29, 139), (BlockPos)pos);
        }

        @Override
        public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
            float rotationYawHead = placer != null ? placer.getYHeadRot() : 0.0f;
            level.getBlockEntity(pos, Holder.FLEX_MARKER_TYPE).ifPresent(t -> t.init(Direction.fromYRot((double)rotationYawHead)));
        }
    }

    protected static abstract class WaterloggedMarker
    extends BlockExMarker
    implements SimpleWaterloggedBlock {
        protected WaterloggedMarker(BlockBehaviour.Properties properties, String name) {
            super(properties, name);
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        }

        public BlockState getStateForPlacement(BlockPlaceContext ctx) {
            FluidState fluid = ctx.getLevel().getFluidState(ctx.getClickedPos());
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluid.is((Fluid)Fluids.WATER)));
        }

        protected abstract BlockExMarker getBaseBlock();

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return BlockWaterloggedMarker.SHAPE;
        }

        @Override
        protected void openGUI(Level worldIn, BlockPos pos, Player playerIn) {
            this.getBaseBlock().openGUI(worldIn, pos, playerIn);
        }

        @Override
        public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
            return true;
        }

        @Override
        public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
            this.getBaseBlock().setPlacedBy(level, pos, state, placer, stack);
        }

        @Override
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return this.getBaseBlock().newBlockEntity(pos, state);
        }

        @Override
        public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pNeighborPos) {
            if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                level.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            }
            return super.updateShape(state, direction, neighborState, level, pCurrentPos, pNeighborPos);
        }

        public FluidState getFluidState(BlockState state) {
            return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
        }
    }
}

