/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.marker.TileMarker;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockMarker
extends QPBlock
implements EntityBlock {
    private static final VoxelShape STANDING_Shape = Shapes.box((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    private static final VoxelShape DOWN_Shape = Shapes.box((double)0.35, (double)0.35, (double)0.35, (double)0.65, (double)1.0, (double)0.65);
    private static final VoxelShape NORTH_Shape = Shapes.box((double)0.35, (double)0.35, (double)0.35, (double)0.65, (double)0.65, (double)1.0);
    private static final VoxelShape SOUTH_Shape = Shapes.box((double)0.35, (double)0.35, (double)0.0, (double)0.65, (double)0.65, (double)0.65);
    private static final VoxelShape WEST_Shape = Shapes.box((double)0.35, (double)0.35, (double)0.35, (double)1.0, (double)0.65, (double)0.65);
    private static final VoxelShape EAST_Shape = Shapes.box((double)0.0, (double)0.35, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    public static final String NAME = "marker";

    public BlockMarker() {
        super(BlockBehaviour.Properties.of((Material)Material.DECORATION).lightLevel(value -> 7).noCollission(), NAME);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getClickedFace());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Holder.MARKER_TYPE.create(pos, state);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof TileMarker) {
            TileMarker marker = (TileMarker)blockEntity;
            marker.tryConnect(true);
            marker.getArea().ifPresent(area -> player.displayClientMessage((Component)new TextComponent("%sMarker Area%s: %s".formatted(ChatFormatting.AQUA, ChatFormatting.RESET, area)), false));
        }
        return InteractionResult.SUCCESS;
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> STANDING_Shape;
            case Direction.DOWN -> DOWN_Shape;
            case Direction.EAST -> EAST_Shape;
            case Direction.WEST -> WEST_Shape;
            case Direction.NORTH -> NORTH_Shape;
            case Direction.SOUTH -> SOUTH_Shape;
        };
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos currentPos, BlockPos neighborPos) {
        return state.canSurvive((LevelReader)world, currentPos) ? state : Blocks.AIR.defaultBlockState();
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        BlockEntity blockEntity;
        super.neighborChanged(state, world, pos, block, fromPos, notify);
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof TileMarker) {
            TileMarker marker = (TileMarker)blockEntity;
            marker.rsReceiving = world.hasNeighborSignal(pos);
            marker.sync();
        }
    }
}

