/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.machines.marker.TileFlexMarker;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.utils.MapMulti;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public final class FlexMarkerMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final TileFlexMarker.Movable movable;
    private final int amount;

    public FlexMarkerMessage(Level world, BlockPos pos, TileFlexMarker.Movable movable, int amount) {
        this.pos = pos;
        this.dim = world != null ? world.dimension() : Level.OVERWORLD;
        this.movable = movable;
        this.amount = amount;
    }

    public FlexMarkerMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.dim = ResourceKey.create((ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)buffer.readResourceLocation());
        this.movable = (TileFlexMarker.Movable)buffer.readEnum(TileFlexMarker.Movable.class);
        this.amount = buffer.readVarInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos).writeResourceLocation(this.dim.location());
        buffer.writeEnum((Enum)this.movable);
        buffer.writeVarInt(this.amount);
    }

    public static void onReceive(FlexMarkerMessage message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> world = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> world.map(w -> w.getBlockEntity(message.pos)).flatMap(MapMulti.optCast(TileFlexMarker.class)).ifPresent(m -> {
            m.move(message.movable, message.amount);
            PacketHandler.sendToClient(new TileMessage((BlockEntity)m), Objects.requireNonNull(m.getLevel()));
        }));
    }
}

