/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.machines.marker.Tile16Marker;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.utils.MapMulti;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public final class Marker16Message
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final int amount;
    private final int yMax;
    private final int yMin;

    public Marker16Message(Level world, BlockPos pos, int amount, int yMax, int yMin) {
        this.pos = pos;
        this.dim = world != null ? world.dimension() : Level.OVERWORLD;
        this.amount = amount;
        this.yMax = yMax;
        this.yMin = yMin;
    }

    public Marker16Message(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.dim = ResourceKey.create((ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)buffer.readResourceLocation());
        this.amount = buffer.readVarInt();
        this.yMax = buffer.readVarInt();
        this.yMin = buffer.readVarInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos).writeResourceLocation(this.dim.location());
        buffer.writeVarInt(this.amount);
        buffer.writeVarInt(this.yMax);
        buffer.writeVarInt(this.yMin);
    }

    public static void onReceive(Marker16Message message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> world = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> world.map(w -> w.getBlockEntity(message.pos)).flatMap(MapMulti.optCast(Tile16Marker.class)).ifPresent(m -> {
            m.changeSize(message.amount, message.yMax, message.yMin);
            PacketHandler.sendToClient(new TileMessage((BlockEntity)m), Objects.requireNonNull(m.getLevel()));
        }));
    }
}

