/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.marker.ContainerMarker;
import com.yogpc.qp.machines.marker.Marker16Message;
import com.yogpc.qp.machines.marker.Tile16Marker;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.packet.PacketHandler;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Screen16Marker
extends AbstractContainerScreen<ContainerMarker>
implements Button.OnPress {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/marker.png");
    private static final int CHUNK = 16;
    private final Tile16Marker marker;
    private static final int BUTTON_WIDTH = 40;

    public Screen16Marker(ContainerMarker containerMarker, Inventory inventory, Component component) {
        super((AbstractContainerMenu)containerMarker, inventory, component);
        this.marker = (Tile16Marker)inventory.player.level.getBlockEntity(containerMarker.pos);
        this.imageWidth = 217;
        this.imageHeight = 188;
        this.inventoryLabelY = this.imageHeight - 96 + 2;
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        this.renderTooltip(matrices, mouseX, mouseY);
    }

    protected void renderBg(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION);
        this.blit(matrices, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(PoseStack matrices, int mouseX, int mouseY) {
        super.renderLabels(matrices, mouseX, mouseY);
        this.font.draw(matrices, "Size", (float)(this.imageWidth - this.font.width("Size")) / 2.0f, 6.0f, 0x404040);
        String sizeText = Integer.toString(this.marker.getSize() / 16);
        this.font.draw(matrices, sizeText, (float)(this.imageWidth - this.font.width(sizeText)) / 2.0f, 38.0f, 0x404040);
        String yMaxText = Integer.toString(this.marker.max().getY());
        String yMinText = Integer.toString(this.marker.min().getY());
        this.font.draw(matrices, yMaxText, (float)(this.imageWidth - this.font.width(yMaxText)) / 2.0f + 10.0f + 40.0f, 38.0f, 0x404040);
        this.font.draw(matrices, yMinText, (float)(this.imageWidth - this.font.width(yMinText)) / 2.0f - 10.0f - 40.0f, 38.0f, 0x404040);
    }

    public void init() {
        super.init();
        int tp = 15;
        int middle = this.getGuiLeft() + this.imageWidth / 2;
        AtomicInteger id = new AtomicInteger(0);
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle - 20, this.getGuiTop() + 15, 40, 20, (Component)new TextComponent("+"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle - 20, this.getGuiTop() + 15 + 33, 40, 20, (Component)new TextComponent("-"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle + 20 + 10, this.getGuiTop() + 15, 40, 20, (Component)new TextComponent("Top+"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle + 20 + 10, this.getGuiTop() + 15 + 33, 40, 20, (Component)new TextComponent("Top-"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle - 20 - 10 - 40, this.getGuiTop() + 15, 40, 20, (Component)new TextComponent("Bottom+"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle - 20 - 10 - 40, this.getGuiTop() + 15 + 33, 40, 20, (Component)new TextComponent("Bottom-"), this));
    }

    public void onPress(Button button) {
        int size = this.marker.getSize();
        int yMin = this.marker.min().getY();
        int yMax = this.marker.max().getY();
        int n = Screen.hasShiftDown() ? 16 : (Screen.hasControlDown() ? 4 : 1);
        if (button instanceof IndexedButton) {
            switch (((IndexedButton)button).getIndex()) {
                case 0: {
                    size = this.marker.getSize() + 16;
                    break;
                }
                case 1: {
                    if (this.marker.getSize() > 16) {
                        size = this.marker.getSize() - 16;
                        break;
                    }
                    size = this.marker.getSize();
                    break;
                }
                case 2: {
                    yMax = this.marker.max().getY() + n;
                    break;
                }
                case 3: {
                    yMax = Math.max(this.marker.max().getY() - n, yMin);
                    break;
                }
                case 4: {
                    yMin = Math.min(this.marker.min().getY() + n, yMax);
                    break;
                }
                case 5: {
                    yMin = this.marker.min().getY() - n;
                }
            }
        }
        PacketHandler.sendToServer(new Marker16Message(this.marker.getLevel(), this.marker.getBlockPos(), size, yMax, yMin));
    }
}

