/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machines.marker.ContainerMarker;
import com.yogpc.qp.machines.marker.FlexMarkerMessage;
import com.yogpc.qp.machines.marker.TileFlexMarker;
import com.yogpc.qp.packet.PacketHandler;
import java.util.stream.Stream;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenFlexMarker
extends AbstractContainerScreen<ContainerMarker> {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/flex_marker.png");
    private static final int upSide = 1;
    private static final int center = 3;
    private static final int downSide = 1;
    private static final int[] amounts = new int[]{-16, -1, 1, 16};
    private final TileFlexMarker marker;
    private static final int yOffsetCenter = 45;
    private static final int yOffsetBottom = 90;

    public ScreenFlexMarker(ContainerMarker containerMarker, Inventory inventory, Component component) {
        super((AbstractContainerMenu)containerMarker, inventory, component);
        this.imageWidth = 217;
        this.imageHeight = 220;
        this.inventoryLabelY = this.imageHeight - 96 + 2;
        this.marker = (TileFlexMarker)containerMarker.player.getLevel().getBlockEntity(containerMarker.pos);
    }

    public void init() {
        int j;
        int i;
        super.init();
        TextComponent[] mp = (TextComponent[])Stream.of("--", "-", "+", "++").map(TextComponent::new).toArray(TextComponent[]::new);
        int w = Stream.of(mp).mapToInt(arg_0 -> ((Font)this.font).width(arg_0)).max().orElseThrow();
        int h = 20;
        int top = 16;
        for (i = 0; i < 1; ++i) {
            for (j = 0; j < mp.length; ++j) {
                this.addRenderableWidget((GuiEventListener)new Button(this.getGuiLeft() + this.imageWidth / 2 - 4 * w * 1 / 2 + w * j, this.getGuiTop() + top, w, h, (Component)mp[j], this::actionPerformed));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < mp.length; ++j) {
                this.addRenderableWidget((GuiEventListener)new Button(this.getGuiLeft() + this.imageWidth / 2 - 4 * w * 3 / 2 + i * w * mp.length + w * j, this.getGuiTop() + top + 45, w, h, (Component)mp[j], this::actionPerformed));
            }
        }
        for (i = 0; i < 1; ++i) {
            for (j = 0; j < mp.length; ++j) {
                this.addRenderableWidget((GuiEventListener)new Button(this.getGuiLeft() + this.imageWidth / 2 - 4 * w * 1 / 2 + w * j, this.getGuiTop() + top + 90, w, h, (Component)mp[j], this::actionPerformed));
            }
        }
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        super.render(matrices, mouseX, mouseY, delta);
        this.renderTooltip(matrices, mouseX, mouseY);
    }

    protected void renderBg(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION);
        this.blit(matrices, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(PoseStack matrices, int mouseX, int mouseY) {
        super.renderLabels(matrices, mouseX, mouseY);
        TranslatableComponent s = new TranslatableComponent(TileFlexMarker.Movable.UP.transName);
        this.font.draw(matrices, (Component)s, ((float)this.imageWidth - (float)this.font.width((FormattedText)s)) / 2.0f, 6.0f, 0x404040);
        s = new TranslatableComponent(TileFlexMarker.Movable.FORWARD.transName);
        this.font.draw(matrices, (Component)s, ((float)this.imageWidth - (float)this.font.width((FormattedText)s)) / 2.0f, 51.0f, 0x404040);
        s = new TranslatableComponent(TileFlexMarker.Movable.LEFT.transName);
        this.font.draw(matrices, (Component)s, ((float)this.imageWidth - (float)this.font.width((FormattedText)s)) / 2.0f - 40.0f, 51.0f, 0x404040);
        s = new TranslatableComponent(TileFlexMarker.Movable.RIGHT.transName);
        this.font.draw(matrices, (Component)s, ((float)this.imageWidth - (float)this.font.width((FormattedText)s)) / 2.0f + 40.0f, 51.0f, 0x404040);
        s = new TranslatableComponent(TileFlexMarker.Movable.DOWN.transName);
        this.font.draw(matrices, (Component)s, ((float)this.imageWidth - (float)this.font.width((FormattedText)s)) / 2.0f, 96.0f, 0x404040);
        this.marker.getArea().ifPresent(area -> {
            String start = "(%d, %d, %d)".formatted(area.minX(), area.minY(), area.minZ());
            String end = "(%d, %d, %d)".formatted(area.maxX(), area.maxY(), area.maxZ());
            float x = (float)this.imageWidth - (float)Math.max(this.font.width(start), this.font.width(end)) - 10.0f;
            this.font.draw(matrices, start, x, 101.0f, 0x404040);
            this.font.draw(matrices, end, x, 111.0f, 0x404040);
            BlockPos minPos = new BlockPos(area.minX(), area.minY(), area.minZ());
            BlockPos maxPos = new BlockPos(area.maxX(), area.maxY(), area.maxZ());
            String distanceUp = String.valueOf(TileFlexMarker.Movable.UP.distanceFromOrigin(this.marker.getBlockPos(), minPos, maxPos, this.marker.direction));
            String distanceLeft = String.valueOf(TileFlexMarker.Movable.LEFT.distanceFromOrigin(this.marker.getBlockPos(), minPos, maxPos, this.marker.direction));
            String distanceForward = String.valueOf(TileFlexMarker.Movable.FORWARD.distanceFromOrigin(this.marker.getBlockPos(), minPos, maxPos, this.marker.direction));
            String distanceRight = String.valueOf(TileFlexMarker.Movable.RIGHT.distanceFromOrigin(this.marker.getBlockPos(), minPos, maxPos, this.marker.direction));
            String distanceDown = String.valueOf(TileFlexMarker.Movable.DOWN.distanceFromOrigin(this.marker.getBlockPos(), minPos, maxPos, this.marker.direction));
            this.font.draw(matrices, distanceUp, ((float)this.imageWidth - (float)this.font.width(distanceUp)) / 2.0f, 38.0f, 0x404040);
            this.font.draw(matrices, distanceLeft, ((float)this.imageWidth - (float)this.font.width(distanceLeft)) / 2.0f - 40.0f, 83.0f, 0x404040);
            this.font.draw(matrices, distanceForward, ((float)this.imageWidth - (float)this.font.width(distanceForward)) / 2.0f, 83.0f, 0x404040);
            this.font.draw(matrices, distanceRight, ((float)this.imageWidth - (float)this.font.width(distanceRight)) / 2.0f + 40.0f, 83.0f, 0x404040);
            this.font.draw(matrices, distanceDown, ((float)this.imageWidth - (float)this.font.width(distanceDown)) / 2.0f, 128.0f, 0x404040);
        });
    }

    public void actionPerformed(Button button) {
        int id = super.children().indexOf(button);
        if (id >= 0) {
            TileFlexMarker.Movable movable = TileFlexMarker.Movable.valueOf(id / 4);
            FlexMarkerMessage message = new FlexMarkerMessage(((ContainerMarker)this.getMenu()).player.level, ((ContainerMarker)this.getMenu()).pos, movable, amounts[id % 4]);
            PacketHandler.sendToServer(message);
        }
    }
}

