/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.RenderMarker;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class Tile16Marker
extends BlockEntity
implements QuarryMarker,
CheckerLog {
    private BlockPos min = BlockPos.ZERO;
    private BlockPos max = BlockPos.ZERO;
    @Nullable
    public Box[] boxes;
    private Direction.AxisDirection xDirection = Direction.AxisDirection.NEGATIVE;
    private Direction.AxisDirection zDirection = Direction.AxisDirection.POSITIVE;
    private int size = 16;

    public Tile16Marker(BlockPos pos, BlockState state) {
        super(Holder.MARKER_16_TYPE, pos, state);
    }

    public void init(Direction.AxisDirection xDirection, Direction.AxisDirection zDirection) {
        this.xDirection = Objects.requireNonNull(xDirection);
        this.zDirection = Objects.requireNonNull(zDirection);
        this.changeSize(this.size);
    }

    public void changeSize(int size) {
        int y = this.getBlockPos().getY();
        this.changeSize(size, y, y);
    }

    public void changeSize(int size, int yMax, int yMin) {
        this.size = size;
        BlockPos edge1 = this.getBlockPos().offset(this.xDirection.getStep() * (size + 1), 0, this.zDirection.getStep() * (size + 1));
        BlockPos edge2 = this.getBlockPos();
        this.min = new BlockPos(Math.min(edge1.getX(), edge2.getX()), yMin, Math.min(edge1.getZ(), edge2.getZ()));
        this.max = new BlockPos(Math.max(edge1.getX(), edge2.getX()), yMax, Math.max(edge1.getZ(), edge2.getZ()));
        if (this.level != null && this.level.isClientSide) {
            this.setRender();
        }
    }

    private void setRender() {
        this.boxes = RenderMarker.getRenderBox(new Area((Vec3i)this.min, (Vec3i)this.max, Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)this.xDirection)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSize() {
        return this.size;
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.min = BlockPos.of((long)compound.getLong("min"));
        this.max = BlockPos.of((long)compound.getLong("max"));
        this.xDirection = compound.getBoolean("x") ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        this.zDirection = compound.getBoolean("z") ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        this.size = compound.getInt("size");
        if (this.level != null && this.level.isClientSide) {
            this.setRender();
        }
    }

    protected void saveAdditional(CompoundTag compound) {
        compound.putLong("min", this.min.asLong());
        compound.putLong("max", this.max.asLong());
        compound.putBoolean("x", this.xDirection == Direction.AxisDirection.POSITIVE);
        compound.putBoolean("z", this.zDirection == Direction.AxisDirection.POSITIVE);
        compound.putInt("size", this.size);
        super.saveAdditional(compound);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.min, this.max);
    }

    public BlockPos min() {
        return this.min == BlockPos.ZERO ? this.getBlockPos() : this.min;
    }

    public BlockPos max() {
        return this.max == BlockPos.ZERO ? this.getBlockPos() : this.max;
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("Size: " + this.size, "Min: " + String.valueOf(this.min()), "Max: " + String.valueOf(this.max())).map(TextComponent::new).toList();
    }

    @Override
    public Optional<Area> getArea() {
        return Optional.of(new Area((Vec3i)this.min, (Vec3i)this.max, Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)this.xDirection)));
    }

    @Override
    public List<ItemStack> removeAndGetItems() {
        assert (this.level != null);
        this.level.removeBlock(this.getBlockPos(), false);
        return List.of(new ItemStack((ItemLike)this.getBlockState().getBlock()));
    }
}

