/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.RenderMarker;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TileFlexMarker
extends BlockEntity
implements QuarryMarker,
CheckerLog {
    private BlockPos min;
    private BlockPos max;
    @Nullable
    public Box[] boxes;
    @Nullable
    public Box directionBox;
    public Direction direction;

    public TileFlexMarker(BlockPos pos, BlockState state) {
        super(Holder.FLEX_MARKER_TYPE, pos, state);
        this.min = pos;
        this.max = pos;
    }

    public void init(Direction facing) {
        this.direction = facing;
        this.min = this.getBlockPos();
        this.max = this.getBlockPos();
        this.move(Movable.LEFT, 5);
        this.move(Movable.RIGHT, 5);
        this.move(Movable.FORWARD, 10);
        if (this.level != null && this.level.isClientSide) {
            this.setRender();
        }
    }

    private int getMaxRange() {
        return (Integer)QuarryPlus.config.common.flexMarkerMaxDistance.get();
    }

    void move(Movable movable, int amount) {
        assert (this.level != null);
        Direction facing = movable.getActualFacing(this.direction);
        BlockPos offset = this.getBlockPos();
        if (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            this.max = this.max.relative(facing, amount);
            int d = TileFlexMarker.getDistance(this.max, offset, facing.getAxis());
            if (d > this.getMaxRange()) {
                this.max = TileFlexMarker.getLimited(this.max, offset, facing, this.getMaxRange());
            } else if (d < 0) {
                this.max = TileFlexMarker.getLimited(this.max, offset, facing, 0);
            }
        } else {
            this.min = this.min.relative(facing, amount);
            int d = TileFlexMarker.getDistance(offset, this.min, facing.getAxis());
            if (d > this.getMaxRange()) {
                this.min = TileFlexMarker.getLimited(this.min, offset, facing, this.getMaxRange());
            } else if (d < 0) {
                this.min = TileFlexMarker.getLimited(this.min, offset, facing, 0);
            }
            if (facing == Direction.DOWN && this.min.getY() < this.level.getMinBuildHeight()) {
                this.min = new BlockPos(this.min.getX(), this.level.getMinBuildHeight(), this.min.getZ());
            }
        }
    }

    private void setRender() {
        if (this.level == null) {
            return;
        }
        Area area = new Area((Vec3i)this.min, (Vec3i)this.max, this.direction);
        this.boxes = RenderMarker.getRenderBox(area);
        double a = 0.5;
        double c = 0.375;
        AABB bb = this.direction == null ? new AABB((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5) : (this.direction.getAxis() == Direction.Axis.X ? new AABB((double)this.getBlockPos().getX() - 0.375 + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, (double)this.getBlockPos().getX() + 0.375 + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5) : new AABB((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() - 0.375 + 0.5, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.375 + 0.5));
        this.directionBox = Box.apply(bb.move(Vec3.atLowerCornerOf((Vec3i)this.direction.getNormal()).scale(0.5)), 0.125, 0.125, 0.125, true, true);
    }

    protected void saveAdditional(CompoundTag compound) {
        compound.putLong("min", this.min.asLong());
        compound.putLong("max", this.max.asLong());
        compound.putString("direction", Optional.ofNullable(this.direction).map(Direction::toString).orElse(""));
        super.saveAdditional(compound);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.min = BlockPos.of((long)compound.getLong("min"));
        this.max = BlockPos.of((long)compound.getLong("max"));
        this.direction = Direction.byName((String)compound.getString("direction"));
        if (this.level != null && this.level.isClientSide) {
            this.setRender();
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.min, this.max);
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("Direction: " + String.valueOf(this.direction), "Min: " + String.valueOf(this.min), "Max: " + String.valueOf(this.max)).map(TextComponent::new).toList();
    }

    @Override
    public Optional<Area> getArea() {
        if (this.direction == null) {
            return Optional.empty();
        }
        return Optional.of(new Area((Vec3i)this.min, (Vec3i)this.max, this.direction));
    }

    @Override
    public List<ItemStack> removeAndGetItems() {
        assert (this.level != null);
        this.level.removeBlock(this.getBlockPos(), false);
        return List.of(new ItemStack((ItemLike)this.getBlockState().getBlock()));
    }

    public static int getDistance(BlockPos to, BlockPos from, Direction.Axis axis) {
        return to.get(axis) - from.get(axis);
    }

    public static BlockPos getLimited(BlockPos to, BlockPos from, Direction facing, int limit) {
        return switch (facing.getAxis()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new BlockPos(from.getX(), to.getY(), to.getZ()).relative(facing, limit);
            case Direction.Axis.Y -> new BlockPos(to.getX(), from.getY(), to.getZ()).relative(facing, limit);
            case Direction.Axis.Z -> new BlockPos(to.getX(), to.getY(), from.getZ()).relative(facing, limit);
        };
    }

    public static enum Movable {
        UP(facing -> Direction.UP),
        LEFT(Direction::getCounterClockWise),
        FORWARD(UnaryOperator.identity()),
        RIGHT(Direction::getClockWise),
        DOWN(facing -> Direction.DOWN);

        private final UnaryOperator<Direction> operator;
        public final String transName;

        private Movable(UnaryOperator<Direction> operator) {
            this.operator = operator;
            this.transName = "gui." + this.name().toLowerCase(Locale.US);
        }

        public Direction getActualFacing(Direction facing) {
            return (Direction)this.operator.apply(facing);
        }

        public static Movable valueOf(int i) {
            return Movable.values()[i];
        }

        public int distanceFromOrigin(BlockPos origin, BlockPos areaMin, BlockPos areaMax, Direction facing) {
            Direction actualFacing = this.getActualFacing(facing);
            BlockPos relative = actualFacing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? areaMax : areaMin;
            return Math.abs(TileFlexMarker.getDistance(origin, relative, actualFacing.getAxis()));
        }
    }
}

