/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.RenderMarker;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileMarker
extends BlockEntity
implements QuarryMarker,
CheckerLog,
ClientSync {
    public static final int MAX_SEARCH = 256;
    private MarkerConnection markerConnection = MarkerConnection.EMPTY;
    @Nullable
    private RenderBox renderBox;
    public boolean rsReceiving;

    public TileMarker(BlockPos pos, BlockState state) {
        super(Holder.MARKER_TYPE, pos, state);
    }

    void tryConnect(boolean first) {
        assert (this.getLevel() != null);
        Optional zMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).mapToObj(i -> this.getBlockPos().relative(Direction.NORTH, i)).flatMap(p -> this.getLevel().getBlockEntity(p, Holder.MARKER_TYPE).stream()).findFirst();
        Optional xMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).mapToObj(i -> this.getBlockPos().relative(Direction.EAST, i)).flatMap(p -> this.getLevel().getBlockEntity(p, Holder.MARKER_TYPE).stream()).findFirst();
        Optional yMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).filter(y -> !this.getLevel().isOutsideBuildHeight(y)).boxed().flatMap(y -> Stream.concat(Stream.of(this.getBlockPos()), Stream.concat(xMarker.stream(), zMarker.stream()).map(BlockEntity::getBlockPos)).map(p -> p.relative(Direction.Axis.Y, y.intValue())).flatMap(p -> this.getLevel().getBlockEntity(p, Holder.MARKER_TYPE).stream())).findFirst();
        MarkerConnection.set(this, xMarker.orElse(null), zMarker.orElse(null), yMarker.orElse(null));
        if (first && this.markerConnection == MarkerConnection.EMPTY) {
            xMarker.ifPresent(marker -> marker.tryConnect(false));
        }
        if (first && this.markerConnection == MarkerConnection.EMPTY) {
            zMarker.ifPresent(marker -> marker.tryConnect(false));
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level != null && !this.level.isClientSide) {
            this.markerConnection.markerPlaces().stream().flatMap(p -> this.level.getBlockEntity(p, Holder.MARKER_TYPE).stream()).forEach(TileMarker::resetConnection);
        }
    }

    private static void resetConnection(TileMarker m) {
        m.markerConnection = MarkerConnection.EMPTY;
        m.sync();
    }

    @Override
    public Optional<Area> getArea() {
        return this.markerConnection.getArea();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<Box[]> renderArea() {
        if (this.markerConnection.render()) {
            if (this.renderBox == null || this.renderBox.parent != this.markerConnection) {
                if (this.markerConnection.area != null) {
                    this.renderBox = new RenderBox(this.markerConnection, RenderMarker.getRenderBox(this.markerConnection.area));
                    return Optional.of(this.renderBox.boxes);
                }
                return Optional.empty();
            }
            return Optional.of(this.renderBox.boxes);
        }
        return Optional.empty();
    }

    @Override
    public List<ItemStack> removeAndGetItems() {
        assert (this.getLevel() != null);
        List<ItemStack> drops = this.markerConnection.markerPlaces().stream().map(arg_0 -> ((Level)this.getLevel()).getBlockState(arg_0)).map(BlockBehaviour.BlockStateBase::getBlock).map(ItemStack::new).toList();
        this.markerConnection.markerPlaces().forEach(p -> this.getLevel().removeBlock(p, false));
        return drops;
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return List.of(new TextComponent("%sMarker Area%s: %s".formatted(ChatFormatting.AQUA, ChatFormatting.RESET, this.markerConnection.getArea())), new TextComponent("%sMarker Poses%s: %s".formatted(ChatFormatting.AQUA, ChatFormatting.RESET, this.markerConnection.markerPlaces())));
    }

    @Override
    public void fromClientTag(CompoundTag tag) {
        this.markerConnection = MarkerConnection.fromClientNbt(tag.getCompound("markerConnection"));
        this.rsReceiving = tag.getBoolean("rsReceiving");
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag) {
        tag.put("markerConnection", (Tag)this.markerConnection.toClientNbt());
        tag.putBoolean("rsReceiving", this.rsReceiving);
        return tag;
    }

    public AABB getRenderBoundingBox() {
        if (this.renderBox != null && this.renderBox.parent.area != null) {
            Area area = this.renderBox.parent.area;
            return new AABB((double)area.minX(), (double)area.minY(), (double)area.minZ(), (double)area.maxX(), (double)area.maxY(), (double)area.maxZ());
        }
        return INFINITE_EXTENT_AABB;
    }

    void sync() {
        if (this.level != null && !this.level.isClientSide) {
            PacketHandler.sendToClient(new ClientSyncMessage(this), this.level);
        }
    }

    record MarkerConnection(@Nullable Area area, @NotNull Set<BlockPos> markerPlaces, boolean render) {
        static final MarkerConnection EMPTY = new MarkerConnection(null, Collections.emptySet(), false);

        static void set(TileMarker thisMarker, @Nullable TileMarker xMarker, @Nullable TileMarker zMarker, @Nullable TileMarker yMarker) {
            if (xMarker != null && zMarker != null) {
                Area area = new Area((Vec3i)xMarker.getBlockPos(), (Vec3i)(yMarker != null ? zMarker.getBlockPos().atY(yMarker.getBlockPos().getY()) : zMarker.getBlockPos().above(4)), Direction.UP);
                MarkerConnection connectionParent = new MarkerConnection(area, Set.of(thisMarker.getBlockPos(), xMarker.getBlockPos(), zMarker.getBlockPos()), true);
                MarkerConnection connectionChild = new MarkerConnection(area, Set.of(thisMarker.getBlockPos(), xMarker.getBlockPos(), zMarker.getBlockPos()), false);
                thisMarker.markerConnection = connectionParent;
                xMarker.markerConnection = connectionChild;
                zMarker.markerConnection = connectionChild;
                thisMarker.sync();
                xMarker.sync();
                zMarker.sync();
                if (yMarker != null) {
                    yMarker.markerConnection = connectionChild;
                    yMarker.sync();
                }
            }
        }

        Optional<Area> getArea() {
            return Optional.ofNullable(this.area);
        }

        CompoundTag toClientNbt() {
            CompoundTag tag = new CompoundTag();
            if (this.area != null) {
                tag.put("area", (Tag)this.area.toNBT());
            }
            tag.putBoolean("render", this.render);
            return tag;
        }

        static MarkerConnection fromClientNbt(CompoundTag tag) {
            Optional area;
            Optional<Object> optional = area = tag.contains("area") ? Area.fromNBT(tag.getCompound("area")) : Optional.empty();
            if (area.isEmpty()) {
                return EMPTY;
            }
            return new MarkerConnection(area.orElse(null), Collections.emptySet(), tag.getBoolean("render"));
        }
    }

    record RenderBox(MarkerConnection parent, Box[] boxes) {
    }
}

