/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.yogpc.qp.QuarryPlus;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

interface BlockStatePredicate {
    public boolean test(BlockState var1, BlockGetter var2, BlockPos var3);

    public static BlockStatePredicate air() {
        return Air.INSTANCE;
    }

    public static BlockStatePredicate fluid() {
        return Fluid.INSTANCE;
    }

    public static BlockStatePredicate name(ResourceLocation location) {
        return new Name(location);
    }

    public static BlockStatePredicate tag(ResourceLocation location) {
        return new Tag(location);
    }

    public static BlockStatePredicate predicateString(String blockPredicate) {
        return new VanillaBlockPredicate(blockPredicate);
    }

    public static BlockStatePredicate all() {
        return All.INSTANCE;
    }

    public static BlockStatePredicate fromTag(CompoundTag tag) {
        String type;
        return switch (type = tag.getString("type")) {
            case "all" -> BlockStatePredicate.all();
            case "air" -> BlockStatePredicate.air();
            case "fluid" -> BlockStatePredicate.fluid();
            case "name" -> BlockStatePredicate.name(new ResourceLocation(tag.getString("location")));
            case "tag" -> BlockStatePredicate.tag(new ResourceLocation(tag.getString("location")));
            case "vanilla" -> BlockStatePredicate.predicateString(tag.getString("predicate"));
            default -> throw new IllegalArgumentException("invalid type name: %s, got from %s".formatted(type, tag));
        };
    }

    public CompoundTag toTag();

    public static final class Air
    implements BlockStatePredicate {
        private static final Air INSTANCE = new Air();

        private Air() {
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return state.isAir();
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("type", this.toString().toLowerCase(Locale.ROOT));
            return tag;
        }

        public String toString() {
            return "Air";
        }
    }

    public static final class Fluid
    implements BlockStatePredicate {
        private static final Fluid INSTANCE = new Fluid();

        private Fluid() {
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return !state.getFluidState().isEmpty();
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("type", this.toString().toLowerCase(Locale.ROOT));
            return tag;
        }

        public String toString() {
            return "Fluid";
        }
    }

    public record Name(ResourceLocation location) implements BlockStatePredicate
    {
        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return this.location.equals((Object)state.getBlock().getRegistryName());
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("type", "name");
            tag.putString("location", this.location.toString());
            return tag;
        }

        @Override
        public String toString() {
            return "Name{location=" + String.valueOf(this.location) + "}";
        }
    }

    public static final class Tag
    implements BlockStatePredicate {
        private final TagKey<Block> tag;
        private final ResourceLocation location;

        private Tag(ResourceLocation tagName) {
            this.location = tagName;
            this.tag = TagKey.create((ResourceKey)Registry.BLOCK_REGISTRY, (ResourceLocation)tagName);
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return state.is(this.tag);
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("type", "tag");
            tag.putString("location", this.location.toString());
            return tag;
        }

        public String toString() {
            return "Tag{" + String.valueOf(this.location) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return this.location.equals((Object)tag.location);
        }

        public int hashCode() {
            return this.location.hashCode();
        }
    }

    public static final class VanillaBlockPredicate
    implements BlockStatePredicate {
        private static final Logger LOGGER = QuarryPlus.getLogger(VanillaBlockPredicate.class);
        private final String blockPredicate;
        @Nullable
        private BlockPredicateArgument.Result argument;

        public VanillaBlockPredicate(String blockPredicate) {
            this.blockPredicate = blockPredicate;
            try {
                this.argument = BlockPredicateArgument.blockPredicate().parse(new StringReader(blockPredicate));
            }
            catch (CommandSyntaxException e) {
                if (!ForgeGameTestHooks.isGametestServer()) {
                    LOGGER.warn("Caught invalid BlockState predicate.", (Throwable)e);
                }
                this.argument = null;
            }
        }

        @Override
        public boolean test(BlockState state, BlockGetter blockGetter, BlockPos pos) {
            if (this.argument != null && blockGetter instanceof Level) {
                Level level = (Level)blockGetter;
                try {
                    return this.argument.create((Registry)Optional.ofNullable(level.getServer()).map(MinecraftServer::registryAccess).flatMap(a -> a.registry(Registry.BLOCK_REGISTRY)).orElseThrow()).test(new BlockInWorld((LevelReader)level, pos, true));
                }
                catch (CommandSyntaxException e) {
                    LOGGER.warn("Caught error in creating predicate.", (Throwable)e);
                    return false;
                }
            }
            return false;
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("type", "vanilla");
            tag.putString("predicate", this.blockPredicate);
            return tag;
        }

        public String toString() {
            return "VanillaBlockPredicate{blockPredicate='" + this.blockPredicate + "'valid=" + (this.argument != null) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VanillaBlockPredicate that = (VanillaBlockPredicate)o;
            return this.blockPredicate.equals(that.blockPredicate);
        }

        public int hashCode() {
            return this.blockPredicate.hashCode();
        }
    }

    public static final class All
    implements BlockStatePredicate {
        private static final All INSTANCE = new All();

        private All() {
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return true;
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("type", this.toString().toLowerCase(Locale.ROOT));
            return tag;
        }

        public String toString() {
            return "All";
        }
    }
}

