/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.mini_quarry.BlockStatePredicate;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryListGui;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryTile;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public final class MiniListSyncMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final Collection<BlockStatePredicate> allowList;
    private final Collection<BlockStatePredicate> denyList;

    public MiniListSyncMessage(BlockPos pos, ResourceKey<Level> dim, Collection<BlockStatePredicate> denyList, Collection<BlockStatePredicate> allowList) {
        this.pos = pos;
        this.dim = dim;
        this.allowList = allowList;
        this.denyList = denyList;
    }

    public MiniListSyncMessage(MiniQuarryTile tile) {
        this(tile.getBlockPos(), PacketHandler.getDimension(tile), tile.denyList, tile.allowList);
    }

    public MiniListSyncMessage(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.dim = ResourceKey.create((ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)buf.readResourceLocation());
        int allowListSize = buf.readInt();
        this.allowList = Stream.generate(() -> ((FriendlyByteBuf)buf).readNbt()).limit(allowListSize).filter(Objects::nonNull).map(BlockStatePredicate::fromTag).toList();
        int denyListSize = buf.readInt();
        this.denyList = Stream.generate(() -> ((FriendlyByteBuf)buf).readNbt()).limit(denyListSize).filter(Objects::nonNull).map(BlockStatePredicate::fromTag).toList();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos).writeResourceLocation(this.dim.location());
        buf.writeInt(this.allowList.size());
        this.allowList.stream().map(BlockStatePredicate::toTag).forEach(arg_0 -> ((FriendlyByteBuf)buf).writeNbt(arg_0));
        buf.writeInt(this.denyList.size());
        this.denyList.stream().map(BlockStatePredicate::toTag).forEach(arg_0 -> ((FriendlyByteBuf)buf).writeNbt(arg_0));
    }

    public static void onReceive(MiniListSyncMessage message, Supplier<NetworkEvent.Context> supplier) {
        switch (supplier.get().getDirection().getReceptionSide()) {
            case SERVER: {
                MiniListSyncMessage.inServer(message, supplier);
                break;
            }
            case CLIENT: {
                MiniListSyncMessage.inClient(message, supplier);
            }
        }
    }

    static void inServer(MiniListSyncMessage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> PacketHandler.getWorld((NetworkEvent.Context)supplier.get(), message.pos, message.dim).flatMap(w -> w.getBlockEntity(message.pos, Holder.MINI_QUARRY_TYPE)).ifPresent(t -> {
            t.allowList = message.allowList;
            t.denyList = message.denyList;
        }));
    }

    @OnlyIn(value=Dist.CLIENT)
    static void inClient(MiniListSyncMessage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> PacketHandler.getWorld((NetworkEvent.Context)supplier.get(), message.pos, message.dim).flatMap(w -> w.getBlockEntity(message.pos, Holder.MINI_QUARRY_TYPE)).ifPresent(t -> Minecraft.getInstance().pushGuiLayer((Screen)new MiniQuarryListGui((MiniQuarryTile)t, message.allowList, message.denyList))));
    }
}

