/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.mini_quarry.BlockStatePredicate;
import com.yogpc.qp.machines.misc.IndexedButton;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class MiniQuarryAddEntryGui
extends Screen
implements Button.OnPress {
    private final Consumer<BlockStatePredicate> callback;
    private EntryList list;
    private EditBox textField;

    protected MiniQuarryAddEntryGui(Screen parent, Consumer<BlockStatePredicate> callback) {
        super(parent.getTitle());
        this.callback = callback;
    }

    protected void init() {
        super.init();
        int buttonWidth = 80;
        int width = this.width;
        int height = this.height;
        this.textField = new EditBox(this.font, width / 2 - 125, height - 56, 250, 20, (Component)new TextComponent(""));
        this.textField.setMaxLength(512);
        this.list = new EntryList(this.getMinecraft(), width, height, 30, height - 70, 18, this, this::getEntries);
        IndexedButton button = new IndexedButton(1, width / 2 - buttonWidth / 2, height - 35, buttonWidth, 20, (Component)new TranslatableComponent("tof.add_new_ore"), this);
        this.addRenderableWidget((GuiEventListener)this.list);
        this.addRenderableWidget((GuiEventListener)this.textField);
        this.addRenderableWidget((GuiEventListener)button);
        this.setInitialFocus((GuiEventListener)this.list);
        this.textField.setCanLoseFocus(true);
        this.textField.setResponder(s -> {
            this.list.setSelected(null);
            this.list.updateList();
            this.list.setScrollAmount(this.list.getScrollAmount());
        });
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.list.render(matrixStack, mouseX, mouseY, partialTicks);
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        MiniQuarryAddEntryGui.drawCenteredString((PoseStack)matrixStack, (Font)this.font, (Component)new TranslatableComponent("quarryplus.gui.new_entry"), (int)(this.width / 2), (int)8, (int)0xFFFFFF);
    }

    private List<Pair<Kind, List<String>>> getEntries() {
        String filterText;
        String string = filterText = this.textField == null ? "" : this.textField.getValue();
        if (filterText.startsWith("#")) {
            String f = filterText.substring(1);
            return List.of(Pair.of((Object)((Object)Kind.TAG), Registry.BLOCK.getTagNames().map(TagKey::location).map(ResourceLocation::toString).filter(r -> r.contains(f)).sorted().collect(Collectors.toList())));
        }
        return List.of(Pair.of((Object)((Object)Kind.ALL), Stream.of("ALL").filter(r -> r.contains(filterText)).toList()), Pair.of((Object)((Object)Kind.BLOCK), ForgeRegistries.BLOCKS.getKeys().stream().map(ResourceLocation::toString).filter(r -> r.contains(filterText)).sorted().collect(Collectors.toList())));
    }

    public void onPress(Button button) {
        IndexedButton indexedButton;
        if (button instanceof IndexedButton && (indexedButton = (IndexedButton)button).id() == 1) {
            LocationEntry entry = (LocationEntry)this.list.getSelected();
            if (entry != null) {
                String location = entry.getData();
                switch (entry.getKind()) {
                    case BLOCK: {
                        this.callback.accept(BlockStatePredicate.name(new ResourceLocation(location)));
                        break;
                    }
                    case TAG: {
                        this.callback.accept(BlockStatePredicate.tag(new ResourceLocation(location)));
                        break;
                    }
                    case ALL: {
                        this.callback.accept(BlockStatePredicate.all());
                        break;
                    }
                    default: {
                        QuarryPlus.LOGGER.warn("Not registered kind {} for {}.", (Object)entry.getKind(), (Object)location);
                        break;
                    }
                }
            } else {
                String maybePredicate = this.textField.getValue();
                if (!maybePredicate.isEmpty()) {
                    try {
                        new BlockStateParser(new StringReader(maybePredicate), true).parse(true);
                        this.callback.accept(BlockStatePredicate.predicateString(maybePredicate));
                    }
                    catch (CommandSyntaxException e) {
                        QuarryPlus.LOGGER.debug("Invalid predicate {} was parsed but not added. Got {}.", (Object)maybePredicate, (Object)e);
                    }
                }
            }
            this.onClose();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (keyCode == 256 || !this.textField.isFocused() && this.getMinecraft().options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    static class EntryList
    extends ObjectSelectionList<LocationEntry> {
        private final Screen parent;
        private final Supplier<List<Pair<Kind, List<String>>>> entriesSupplier;

        public EntryList(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn, Screen parent, Supplier<List<Pair<Kind, List<String>>>> entriesSupplier) {
            super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
            this.parent = parent;
            this.entriesSupplier = entriesSupplier;
            this.updateList();
        }

        public void updateList() {
            this.clearEntries();
            List<Pair<Kind, List<String>>> kindListPairs = this.entriesSupplier.get();
            kindListPairs.forEach(kindListPair -> ((List)kindListPair.getValue()).stream().map(e -> new LocationEntry((String)e, this.parent, arg_0 -> ((EntryList)this).setSelected(arg_0), (Kind)((Object)((Object)((Object)kindListPair.getKey()))))).forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0)));
        }
    }

    private static enum Kind {
        BLOCK,
        TAG,
        ALL;

    }

    static class LocationEntry
    extends ObjectSelectionList.Entry<LocationEntry> {
        private final String data;
        private final Screen parent;
        private final Consumer<LocationEntry> setSelected;
        private final Kind kind;

        LocationEntry(String data, Screen parent, Consumer<LocationEntry> setSelected, Kind kind) {
            this.data = data;
            this.parent = parent;
            this.setSelected = setSelected;
            this.kind = kind;
        }

        public String getData() {
            return this.data;
        }

        public Kind getKind() {
            return this.kind;
        }

        public void render(PoseStack m, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_render_8_, float partialTicks) {
            String name = (this.kind == Kind.TAG ? "#" : "") + this.data;
            Minecraft.getInstance().font.draw(m, name, (float)((this.parent.width - Minecraft.getInstance().font.width(name)) / 2), (float)(top + 2), 0xFFFFFF);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.setSelected.accept(this);
            return false;
        }

        public Component getNarration() {
            return new TranslatableComponent("narrator.select", new Object[]{this.data});
        }
    }
}

