/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryTile;
import com.yogpc.qp.machines.misc.SlotContainer;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class MiniQuarryMenu
extends AbstractContainerMenu {
    public static final String GUI_ID = "quarryplus:gui_mini_quarry";
    final MiniQuarryTile miniQuarry;
    private final int allSlots;

    public MiniQuarryMenu(int id, Player player, BlockPos pos) {
        super(Holder.MINI_QUARRY_MENU_TYPE, id);
        this.miniQuarry = Objects.requireNonNull((MiniQuarryTile)player.level.getBlockEntity(pos));
        this.allSlots = this.miniQuarry.getInv().getContainerSize();
        int oneBox = 18;
        for (int i = 0; i < this.allSlots; ++i) {
            int verticalFix = i < 5 ? i : i - 5;
            int horizontalFix = i / 5;
            this.addSlot(new SlotContainer(this.miniQuarry.getInv(), i, 44 + verticalFix * 18, 27 + horizontalFix * 18));
        }
        for (int h = 0; h < 3; ++h) {
            for (int v = 0; v < 9; ++v) {
                this.addSlot(new Slot((Container)player.getInventory(), v + h * 9 + 9, 8 + v * 18, 84 + h * 18));
            }
        }
        for (int vertical = 0; vertical < 9; ++vertical) {
            this.addSlot(new Slot((Container)player.getInventory(), vertical, 8 + vertical * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return this.miniQuarry.getBlockPos().distToCenterSqr((Position)player.position()) < 64.0;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack remain = slot.getItem();
            ItemStack slotContent = remain.copy();
            if (index < this.allSlots ? !this.moveItemStackTo(remain, this.allSlots, 36 + this.allSlots, true) : !this.moveItemStackTo(remain, 0, this.allSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (remain.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (remain.getCount() == slotContent.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, remain);
            return slotContent;
        }
        return ItemStack.EMPTY;
    }
}

