/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.TargetIterator;
import java.util.Iterator;
import net.minecraft.core.BlockPos;

abstract class MiniTarget
implements Iterator<BlockPos> {
    protected final Area area;
    protected final TargetIterator targetIterator;
    protected int y;

    MiniTarget(Area area) {
        this.area = area;
        this.targetIterator = TargetIterator.of(area);
        this.y = area.maxY();
    }

    static MiniTarget of(Area area, boolean repeat) {
        if (repeat) {
            return new Repeat(area);
        }
        return new Single(area);
    }

    public BlockPos peek() {
        TargetIterator.XZPair pair = (TargetIterator.XZPair)this.targetIterator.peek();
        return new BlockPos(pair.x(), this.y, pair.z());
    }

    @Override
    public BlockPos next() {
        if (this.targetIterator.hasNext()) {
            BlockPos current = this.peek();
            this.targetIterator.next();
            return current;
        }
        this.targetIterator.reset();
        this.y = this.nextY();
        return this.next();
    }

    protected abstract int nextY();

    void setCurrent(BlockPos pos) {
        this.y = pos.getY();
        this.targetIterator.setCurrent(new TargetIterator.XZPair(pos.getX(), pos.getZ()));
    }

    private static class Repeat
    extends MiniTarget {
        private boolean isRepeating;

        Repeat(Area area) {
            super(area);
        }

        @Override
        public boolean hasNext() {
            if (!this.isRepeating || this.y > this.area.minY()) {
                return true;
            }
            return this.targetIterator.hasNext();
        }

        @Override
        protected int nextY() {
            if (this.isRepeating) {
                this.isRepeating = false;
                return this.y - 1;
            }
            this.isRepeating = true;
            return this.y;
        }
    }

    private static class Single
    extends MiniTarget {
        Single(Area area) {
            super(area);
        }

        @Override
        public boolean hasNext() {
            if (this.y > this.area.minY()) {
                return true;
            }
            return this.targetIterator.hasNext();
        }

        @Override
        protected int nextY() {
            return this.y - 1;
        }
    }
}

