/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.miningwell;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.ItemConverter;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerConfig;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.miningwell.MiningWellBlock;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class MiningWellTile
extends PowerTile
implements CheckerLog,
MachineStorage.HasStorage {
    private final MachineStorage storage = new MachineStorage();
    private final ItemConverter itemConverter = ItemConverter.defaultConverter();
    public int digMinY = 0;
    private int interval = 0;
    private boolean finished = false;

    public MiningWellTile(BlockPos pos, BlockState state) {
        super(Holder.MINING_WELL_TYPE, pos, state);
    }

    public void tick() {
        int y;
        assert (this.level != null);
        assert (!this.level.isClientSide);
        if (!this.hasEnoughEnergy() || this.finished || --this.interval > 0) {
            return;
        }
        this.interval = 40;
        if (!((Boolean)this.getBlockState().getValue((Property)MiningWellBlock.WORKING)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)MiningWellBlock.WORKING, (Comparable)Boolean.valueOf(true)), 2);
            this.setChanged();
        }
        for (y = this.getBlockPos().getY() - 1; y >= this.digMinY; --y) {
            BlockPos targetPos = this.getBlockPos().atY(y);
            BlockState state = this.level.getBlockState(targetPos);
            FluidState fluid = this.level.getFluidState(targetPos);
            if (state.isAir()) continue;
            ItemStack pickaxe = new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
            FakePlayer fakePlayer = QuarryFakePlayer.get((ServerLevel)this.level);
            fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, pickaxe);
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.level, targetPos, state, (Player)fakePlayer);
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (breakEvent.isCanceled()) continue;
            if (!fluid.isEmpty()) {
                if (!this.useEnergy(PowerManager.getBreakBlockFluidEnergy(EnchantmentLevel.NoEnchantments.INSTANCE, PowerConfig.DEFAULT), PowerTile.Reason.REMOVE_FLUID, false)) break;
                if (state.getBlock() instanceof LiquidBlock) {
                    if (!fluid.isEmpty() && fluid.isSource()) {
                        this.storage.addFluid(fluid.getType(), 1000L);
                    }
                    this.level.setBlock(targetPos, Blocks.AIR.defaultBlockState(), 3);
                    break;
                }
                Block block = state.getBlock();
                if (block instanceof BucketPickup) {
                    BucketPickup drain = (BucketPickup)block;
                    ItemStack bucket = drain.pickupBlock((LevelAccessor)this.level, targetPos, state);
                    this.storage.addFluid(bucket);
                    break;
                }
                this.level.setBlock(targetPos, Blocks.AIR.defaultBlockState(), 3);
                break;
            }
            if (!this.canBreak(this.level, targetPos, state)) continue;
            this.breakBlock(this.level, targetPos, state);
            break;
        }
        if (y < this.digMinY) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)MiningWellBlock.WORKING, (Comparable)Boolean.valueOf(false)), 2);
            this.setChanged();
            this.finished = true;
        }
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        nbt.put("storage", (Tag)this.storage.toNbt());
        nbt.putInt("digMinY", this.digMinY);
        nbt.putInt("waitingTick", this.interval);
        nbt.putBoolean("finished", this.finished);
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.storage.readNbt(nbt.getCompound("storage"));
        this.digMinY = nbt.getInt("digMinY");
        this.interval = nbt.getInt("waitingTick");
        this.finished = nbt.getBoolean("finished");
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("MinY: " + this.digMinY, "Interval: " + this.interval, "Finished: " + this.finished, this.energyString()).map(TextComponent::new).toList();
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    private boolean canBreak(Level targetWorld, BlockPos targetPos, BlockState state) {
        float hardness = state.getDestroySpeed((BlockGetter)targetWorld, targetPos);
        return hardness >= 0.0f;
    }

    private void breakBlock(Level level, BlockPos pos, BlockState state) {
        float hardness = state.getDestroySpeed((BlockGetter)level, pos);
        if (this.useEnergy(PowerManager.getBreakEnergy(hardness, EnchantmentLevel.NoEnchantments.INSTANCE, PowerConfig.DEFAULT), PowerTile.Reason.BREAK_BLOCK, false)) {
            List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), null, (ItemStack)new ItemStack((ItemLike)Items.NETHERITE_PICKAXE));
            drops.stream().map(this.itemConverter::map).forEach(this.storage::addItem);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            SoundType sound = state.getSoundType();
            level.playSound(null, pos, sound.getBreakSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 4.0f, sound.getPitch() * 0.8f);
        }
    }

    void reset() {
        this.finished = false;
        this.interval = 40;
    }
}

